/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.ForStatement;
import org.sonar.python.api.tree.StatementList;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ForStatementImpl
extends PyTree
implements ForStatement {
    private final Token forKeyword;
    private final List<Expression> expressions;
    private final Token inKeyword;
    private final List<Expression> testExpressions;
    private final Token colon;
    private final StatementList body;
    @Nullable
    private final Token elseKeyword;
    @Nullable
    private final Token elseColon;
    private final StatementList elseBody;
    private final Token asyncKeyword;
    private final boolean isAsync;

    public ForStatementImpl(AstNode astNode, Token forKeyword, List<Expression> expressions, Token inKeyword, List<Expression> testExpressions, Token colon, StatementList body, @Nullable Token elseKeyword, @Nullable Token elseColon, @Nullable StatementList elseBody, @Nullable Token asyncKeyword) {
        super(astNode);
        this.forKeyword = forKeyword;
        this.expressions = expressions;
        this.inKeyword = inKeyword;
        this.testExpressions = testExpressions;
        this.colon = colon;
        this.body = body;
        this.elseKeyword = elseKeyword;
        this.elseColon = elseColon;
        this.elseBody = elseBody;
        this.asyncKeyword = asyncKeyword;
        this.isAsync = asyncKeyword != null;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.FOR_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitForStatement(this);
    }

    @Override
    public Token forKeyword() {
        return this.forKeyword;
    }

    @Override
    public List<Expression> expressions() {
        return this.expressions;
    }

    @Override
    public Token inKeyword() {
        return this.inKeyword;
    }

    @Override
    public List<Expression> testExpressions() {
        return this.testExpressions;
    }

    @Override
    public Token colon() {
        return this.colon;
    }

    @Override
    public StatementList body() {
        return this.body;
    }

    @Override
    @CheckForNull
    public Token elseKeyword() {
        return this.elseKeyword;
    }

    @Override
    @CheckForNull
    public Token elseColon() {
        return this.elseColon;
    }

    @Override
    @CheckForNull
    public StatementList elseBody() {
        return this.elseBody;
    }

    @Override
    public boolean isAsync() {
        return this.isAsync;
    }

    @Override
    @CheckForNull
    public Token asyncKeyword() {
        return this.asyncKeyword;
    }

    @Override
    public List<Tree> children() {
        return Stream.of(Arrays.asList(this.asyncKeyword, this.forKeyword), this.expressions, Collections.singletonList(this.inKeyword), this.testExpressions, Arrays.asList(this.colon, this.body, this.elseKeyword, this.colon, this.elseBody)).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

