/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.api.tree.GlobalStatement;
import org.sonar.python.api.tree.Name;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class GlobalStatementImpl
extends PyTree
implements GlobalStatement {
    private final Token globalKeyword;
    private final List<Name> variables;

    public GlobalStatementImpl(AstNode astNode, Token globalKeyword, List<Name> variables) {
        super(astNode);
        this.globalKeyword = globalKeyword;
        this.variables = variables;
    }

    @Override
    public Token globalKeyword() {
        return this.globalKeyword;
    }

    @Override
    public List<Name> variables() {
        return this.variables;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.GLOBAL_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitGlobalStatement(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(Collections.singletonList(this.globalKeyword), this.variables).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

