/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.python.api.tree.ElseStatement;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.IfStatement;
import org.sonar.python.api.tree.StatementList;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class IfStatementImpl
extends PyTree
implements IfStatement {
    private final Token keyword;
    private final Expression condition;
    private final StatementList statements;
    private final List<IfStatement> elifBranches;
    private final boolean isElif;
    @CheckForNull
    private final ElseStatement elseStatement;

    public IfStatementImpl(Token ifKeyword, Expression condition, StatementList statements, List<IfStatement> elifBranches, @CheckForNull ElseStatement elseStatement) {
        super(ifKeyword, statements.lastToken());
        this.keyword = ifKeyword;
        this.condition = condition;
        this.statements = statements;
        this.elifBranches = elifBranches;
        this.isElif = false;
        this.elseStatement = elseStatement;
    }

    public IfStatementImpl(Token elifKeyword, Expression condition, StatementList statements) {
        super(elifKeyword, statements.lastToken());
        this.keyword = elifKeyword;
        this.condition = condition;
        this.statements = statements;
        this.elifBranches = Collections.emptyList();
        this.isElif = true;
        this.elseStatement = null;
    }

    @Override
    public Token keyword() {
        return this.keyword;
    }

    @Override
    public Expression condition() {
        return this.condition;
    }

    @Override
    public StatementList body() {
        return this.statements;
    }

    @Override
    public List<IfStatement> elifBranches() {
        return this.elifBranches;
    }

    @Override
    public boolean isElif() {
        return this.isElif;
    }

    @Override
    @CheckForNull
    public ElseStatement elseBranch() {
        return this.elseStatement;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.IF_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitIfStatement(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(Arrays.asList(this.keyword, this.condition, this.statements), this.elifBranches, Collections.singletonList(this.elseStatement)).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

