/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.api.tree.AliasedName;
import org.sonar.python.api.tree.DottedName;
import org.sonar.python.api.tree.ImportFrom;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;
import org.sonar.python.tree.TokenImpl;

public class ImportFromImpl
extends PyTree
implements ImportFrom {
    private final Token fromKeyword;
    private final List<Token> dottedPrefixForModule;
    private final DottedName moduleName;
    private final Token importKeyword;
    private final List<AliasedName> aliasedImportNames;
    private final boolean isWildcardImport;
    private final Token wildcard;

    public ImportFromImpl(AstNode astNode, Token fromKeyword, @Nullable List<Token> dottedPrefixForModule, @Nullable DottedName moduleName, Token importKeyword, @Nullable List<AliasedName> aliasedImportNames, boolean isWildcardImport) {
        super(astNode);
        this.fromKeyword = fromKeyword;
        this.dottedPrefixForModule = dottedPrefixForModule;
        this.moduleName = moduleName;
        this.importKeyword = importKeyword;
        this.aliasedImportNames = aliasedImportNames == null ? Collections.emptyList() : aliasedImportNames;
        this.isWildcardImport = isWildcardImport;
        this.wildcard = isWildcardImport ? new TokenImpl(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.MUL}).getToken()) : null;
    }

    @Override
    public Token fromKeyword() {
        return this.fromKeyword;
    }

    @Override
    @CheckForNull
    public DottedName module() {
        return this.moduleName;
    }

    @Override
    public Token importKeyword() {
        return this.importKeyword;
    }

    @Override
    @CheckForNull
    public List<Token> dottedPrefixForModule() {
        return this.dottedPrefixForModule;
    }

    @Override
    public List<AliasedName> importedNames() {
        return this.aliasedImportNames;
    }

    @Override
    public boolean isWildcardImport() {
        return this.isWildcardImport;
    }

    @Override
    @CheckForNull
    public Token wildcard() {
        return this.wildcard;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.IMPORT_FROM;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitImportFrom(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(Collections.singletonList(this.importKeyword), this.aliasedImportNames, Collections.singletonList(this.fromKeyword), this.dottedPrefixForModule, Arrays.asList(this.moduleName, this.wildcard)).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

