/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.api.tree.AliasedName;
import org.sonar.python.api.tree.ImportName;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ImportNameImpl
extends PyTree
implements ImportName {
    private final Token importKeyword;
    private final List<AliasedName> aliasedNames;

    public ImportNameImpl(AstNode astNode, Token importKeyword, List<AliasedName> aliasedNames) {
        super(astNode);
        this.importKeyword = importKeyword;
        this.aliasedNames = aliasedNames;
    }

    @Override
    public Token importKeyword() {
        return this.importKeyword;
    }

    @Override
    public List<AliasedName> modules() {
        return this.aliasedNames;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.IMPORT_NAME;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitImportName(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(Collections.singletonList(this.importKeyword), this.aliasedNames).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

