/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.KeyValuePair;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class KeyValuePairImpl
extends PyTree
implements KeyValuePair {
    private final Token starStarToken;
    private final Expression expression;
    private final Expression key;
    private final Token colon;
    private final Expression value;

    public KeyValuePairImpl(Token starStarToken, Expression expression) {
        super(starStarToken, expression.lastToken());
        this.starStarToken = starStarToken;
        this.expression = expression;
        this.key = null;
        this.colon = null;
        this.value = null;
    }

    public KeyValuePairImpl(Expression key, Token colon, Expression value) {
        super(key.firstToken(), value.lastToken());
        this.key = key;
        this.colon = colon;
        this.value = value;
        this.starStarToken = null;
        this.expression = null;
    }

    @Override
    @CheckForNull
    public Expression key() {
        return this.key;
    }

    @Override
    @CheckForNull
    public Token colon() {
        return this.colon;
    }

    @Override
    @CheckForNull
    public Expression value() {
        return this.value;
    }

    @Override
    @CheckForNull
    public Token starStarToken() {
        return this.starStarToken;
    }

    @Override
    @CheckForNull
    public Expression expression() {
        return this.expression;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitKeyValuePair(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.expression, this.key, this.colon, this.value, this.starStarToken).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.KEY_VALUE_PAIR;
    }
}

