/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.LambdaExpression;
import org.sonar.python.api.tree.ParameterList;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.semantic.Symbol;
import org.sonar.python.tree.PyTree;

public class LambdaExpressionImpl
extends PyTree
implements LambdaExpression {
    private final Token lambdaKeyword;
    private final Token colonToken;
    private final Expression body;
    private final ParameterList parameterList;
    private Set<Symbol> symbols = new HashSet<Symbol>();

    public LambdaExpressionImpl(AstNode astNode, Token lambdaKeyword, Token colonToken, Expression body, @Nullable ParameterList parameterList) {
        super(astNode);
        this.lambdaKeyword = lambdaKeyword;
        this.colonToken = colonToken;
        this.body = body;
        this.parameterList = parameterList;
    }

    @Override
    public Token lambdaKeyword() {
        return this.lambdaKeyword;
    }

    @Override
    public Token colonToken() {
        return this.colonToken;
    }

    @Override
    public Expression expression() {
        return this.body;
    }

    @Override
    @CheckForNull
    public ParameterList parameters() {
        return this.parameterList;
    }

    @Override
    public Set<Symbol> localVariables() {
        return this.symbols;
    }

    @Override
    public boolean isMethodDefinition() {
        return false;
    }

    public void addLocalVariableSymbol(Symbol symbol) {
        this.symbols.add(symbol);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.LAMBDA;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitLambda(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.lambdaKeyword, this.parameterList, this.colonToken, this.body).collect(Collectors.toList());
    }
}

