/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.api.tree.ExpressionList;
import org.sonar.python.api.tree.ListLiteral;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ListLiteralImpl
extends PyTree
implements ListLiteral {
    private final Token leftBracket;
    private final ExpressionList elements;
    private final Token rightBracket;

    public ListLiteralImpl(AstNode astNode, Token leftBracket, ExpressionList elements, Token rightBracket) {
        super(astNode);
        this.leftBracket = leftBracket;
        this.elements = elements;
        this.rightBracket = rightBracket;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.LIST_LITERAL;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitListLiteral(this);
    }

    @Override
    public Token leftBracket() {
        return this.leftBracket;
    }

    @Override
    public ExpressionList elements() {
        return this.elements;
    }

    @Override
    public Token rightBracket() {
        return this.rightBracket;
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.leftBracket, this.elements, this.rightBracket).collect(Collectors.toList());
    }
}

