/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.api.tree.Name;
import org.sonar.python.api.tree.NonlocalStatement;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class NonlocalStatementImpl
extends PyTree
implements NonlocalStatement {
    private final Token nonlocalKeyword;
    private final List<Name> variables;

    public NonlocalStatementImpl(AstNode astNode, Token nonlocalKeyword, List<Name> variables) {
        super(astNode);
        this.nonlocalKeyword = nonlocalKeyword;
        this.variables = variables;
    }

    @Override
    public Token nonlocalKeyword() {
        return this.nonlocalKeyword;
    }

    @Override
    public List<Name> variables() {
        return this.variables;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.NONLOCAL_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitNonlocalStatement(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(Collections.singletonList(this.nonlocalKeyword), this.variables).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

