/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.Name;
import org.sonar.python.api.tree.Parameter;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.api.tree.TypeAnnotation;
import org.sonar.python.tree.PyTree;

public class ParameterImpl
extends PyTree
implements Parameter {
    private final Name name;
    private final TypeAnnotation annotation;
    private final Token equalToken;
    private final Expression defaultValue;
    private final Token starToken;

    public ParameterImpl(AstNode node, @Nullable Token starToken, Name name, @Nullable TypeAnnotation annotation, @Nullable Token equalToken, @Nullable Expression defaultValue) {
        super(node);
        this.starToken = starToken;
        this.name = name;
        this.annotation = annotation;
        this.equalToken = equalToken;
        this.defaultValue = defaultValue;
    }

    @Override
    @CheckForNull
    public Token starToken() {
        return this.starToken;
    }

    @Override
    public Name name() {
        return this.name;
    }

    @Override
    @CheckForNull
    public TypeAnnotation typeAnnotation() {
        return this.annotation;
    }

    @Override
    @CheckForNull
    public Token equalToken() {
        return this.equalToken;
    }

    @Override
    @CheckForNull
    public Expression defaultValue() {
        return this.defaultValue;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.PARAMETER;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitParameter(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.name, this.annotation, this.equalToken, this.defaultValue, this.starToken).collect(Collectors.toList());
    }
}

