/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.python.api.tree.AnyParameter;
import org.sonar.python.api.tree.Parameter;
import org.sonar.python.api.tree.ParameterList;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ParameterListImpl
extends PyTree
implements ParameterList {
    private final List<AnyParameter> parameters;

    public ParameterListImpl(AstNode node, List<AnyParameter> parameters) {
        super(node);
        this.parameters = parameters;
    }

    @Override
    public List<Parameter> nonTuple() {
        return this.parameters.stream().filter(Parameter.class::isInstance).map(Parameter.class::cast).collect(Collectors.toList());
    }

    @Override
    public List<AnyParameter> all() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitParameterList(this);
    }

    @Override
    public List<Tree> children() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.PARAMETER_LIST;
    }
}

