/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.ParenthesizedExpression;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ParenthesizedExpressionImpl
extends PyTree
implements ParenthesizedExpression {
    private final Token leftParenthesis;
    private final Expression expression;
    private final Token rightParenthesis;

    public ParenthesizedExpressionImpl(Token leftParenthesis, Expression expression, Token rightParenthesis) {
        super(leftParenthesis, rightParenthesis);
        this.leftParenthesis = leftParenthesis;
        this.expression = expression;
        this.rightParenthesis = rightParenthesis;
    }

    @Override
    public Token leftParenthesis() {
        return this.leftParenthesis;
    }

    @Override
    public Expression expression() {
        return this.expression;
    }

    @Override
    public Token rightParenthesis() {
        return this.rightParenthesis;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitParenthesizedExpression(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.leftParenthesis, this.expression, this.rightParenthesis).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.PARENTHESIZED;
    }
}

