/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.PrintStatement;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class PrintStatementImpl
extends PyTree
implements PrintStatement {
    private final Token printKeyword;
    private final List<Expression> expressions;

    public PrintStatementImpl(AstNode astNode, Token printKeyword, List<Expression> expressions) {
        super(astNode);
        this.printKeyword = printKeyword;
        this.expressions = expressions;
    }

    @Override
    public Token printKeyword() {
        return this.printKeyword;
    }

    @Override
    public List<Expression> expressions() {
        return this.expressions;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.PRINT_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitPrintStatement(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(Collections.singletonList(this.printKeyword), this.expressions).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

