/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.TokenImpl;

public abstract class PyTree
implements Tree {
    private final AstNode node;
    private final Token firstToken;
    private final Token lastToken;
    private Tree parent = null;

    public PyTree(@Nullable AstNode node) {
        this.node = node;
        this.firstToken = node == null ? null : new TokenImpl(node.getToken());
        this.lastToken = node == null ? null : new TokenImpl(node.getLastToken());
    }

    public PyTree(Token firstToken, Token lastToken) {
        this.node = null;
        this.firstToken = firstToken;
        this.lastToken = lastToken;
    }

    @Override
    public boolean is(Tree.Kind kind) {
        return kind == this.getKind();
    }

    @Override
    @CheckForNull
    public AstNode astNode() {
        return this.node;
    }

    @Override
    public Token firstToken() {
        return this.firstToken;
    }

    @Override
    public Token lastToken() {
        return this.lastToken;
    }

    @Override
    public Tree parent() {
        return this.parent;
    }

    protected void setParent(Tree parent) {
        this.parent = parent;
    }
}

