/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.DocstringExtractor;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.api.tree.AliasedName;
import org.sonar.python.api.tree.AnnotatedAssignment;
import org.sonar.python.api.tree.AnyParameter;
import org.sonar.python.api.tree.ArgList;
import org.sonar.python.api.tree.Argument;
import org.sonar.python.api.tree.AssertStatement;
import org.sonar.python.api.tree.AssignmentStatement;
import org.sonar.python.api.tree.BreakStatement;
import org.sonar.python.api.tree.CallExpression;
import org.sonar.python.api.tree.ClassDef;
import org.sonar.python.api.tree.CompoundAssignmentStatement;
import org.sonar.python.api.tree.ComprehensionClause;
import org.sonar.python.api.tree.ComprehensionFor;
import org.sonar.python.api.tree.ConditionalExpression;
import org.sonar.python.api.tree.ContinueStatement;
import org.sonar.python.api.tree.Decorator;
import org.sonar.python.api.tree.DelStatement;
import org.sonar.python.api.tree.DottedName;
import org.sonar.python.api.tree.ElseStatement;
import org.sonar.python.api.tree.ExceptClause;
import org.sonar.python.api.tree.ExecStatement;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.ExpressionList;
import org.sonar.python.api.tree.ExpressionStatement;
import org.sonar.python.api.tree.FileInput;
import org.sonar.python.api.tree.ForStatement;
import org.sonar.python.api.tree.FunctionDef;
import org.sonar.python.api.tree.GlobalStatement;
import org.sonar.python.api.tree.IfStatement;
import org.sonar.python.api.tree.ImportFrom;
import org.sonar.python.api.tree.ImportName;
import org.sonar.python.api.tree.ImportStatement;
import org.sonar.python.api.tree.KeyValuePair;
import org.sonar.python.api.tree.LambdaExpression;
import org.sonar.python.api.tree.Name;
import org.sonar.python.api.tree.NonlocalStatement;
import org.sonar.python.api.tree.PassStatement;
import org.sonar.python.api.tree.PrintStatement;
import org.sonar.python.api.tree.QualifiedExpression;
import org.sonar.python.api.tree.RaiseStatement;
import org.sonar.python.api.tree.ReturnStatement;
import org.sonar.python.api.tree.SliceItem;
import org.sonar.python.api.tree.Statement;
import org.sonar.python.api.tree.StatementList;
import org.sonar.python.api.tree.StringElement;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TryStatement;
import org.sonar.python.api.tree.WithItem;
import org.sonar.python.api.tree.WithStatement;
import org.sonar.python.api.tree.YieldExpression;
import org.sonar.python.api.tree.YieldStatement;
import org.sonar.python.tree.AliasedNameImpl;
import org.sonar.python.tree.AnnotatedAssignmentImpl;
import org.sonar.python.tree.ArgListImpl;
import org.sonar.python.tree.ArgumentImpl;
import org.sonar.python.tree.AssertStatementImpl;
import org.sonar.python.tree.AssignmentStatementImpl;
import org.sonar.python.tree.AwaitExpressionImpl;
import org.sonar.python.tree.BinaryExpressionImpl;
import org.sonar.python.tree.BreakStatementImpl;
import org.sonar.python.tree.CallExpressionImpl;
import org.sonar.python.tree.ClassDefImpl;
import org.sonar.python.tree.CompoundAssignmentStatementImpl;
import org.sonar.python.tree.ComprehensionExpressionImpl;
import org.sonar.python.tree.ComprehensionForImpl;
import org.sonar.python.tree.ComprehensionIfImpl;
import org.sonar.python.tree.ConditionalExpressionImpl;
import org.sonar.python.tree.ContinueStatementImpl;
import org.sonar.python.tree.DecoratorImpl;
import org.sonar.python.tree.DelStatementImpl;
import org.sonar.python.tree.DictCompExpressionImpl;
import org.sonar.python.tree.DictionaryLiteralImpl;
import org.sonar.python.tree.DottedNameImpl;
import org.sonar.python.tree.EllipsisExpressionImpl;
import org.sonar.python.tree.ElseStatementImpl;
import org.sonar.python.tree.ExceptClauseImpl;
import org.sonar.python.tree.ExecStatementImpl;
import org.sonar.python.tree.ExpressionListImpl;
import org.sonar.python.tree.ExpressionStatementImpl;
import org.sonar.python.tree.FileInputImpl;
import org.sonar.python.tree.FinallyClauseImpl;
import org.sonar.python.tree.ForStatementImpl;
import org.sonar.python.tree.FunctionDefImpl;
import org.sonar.python.tree.GlobalStatementImpl;
import org.sonar.python.tree.IfStatementImpl;
import org.sonar.python.tree.ImportFromImpl;
import org.sonar.python.tree.ImportNameImpl;
import org.sonar.python.tree.InExpressionImpl;
import org.sonar.python.tree.IsExpressionImpl;
import org.sonar.python.tree.KeyValuePairImpl;
import org.sonar.python.tree.LambdaExpressionImpl;
import org.sonar.python.tree.ListLiteralImpl;
import org.sonar.python.tree.NameImpl;
import org.sonar.python.tree.NoneExpressionImpl;
import org.sonar.python.tree.NonlocalStatementImpl;
import org.sonar.python.tree.NumericLiteralImpl;
import org.sonar.python.tree.ParameterImpl;
import org.sonar.python.tree.ParameterListImpl;
import org.sonar.python.tree.ParenthesizedExpressionImpl;
import org.sonar.python.tree.PassStatementImpl;
import org.sonar.python.tree.PrintStatementImpl;
import org.sonar.python.tree.PyTree;
import org.sonar.python.tree.QualifiedExpressionImpl;
import org.sonar.python.tree.RaiseStatementImpl;
import org.sonar.python.tree.ReprExpressionImpl;
import org.sonar.python.tree.ReturnStatementImpl;
import org.sonar.python.tree.SetLiteralImpl;
import org.sonar.python.tree.SliceExpressionImpl;
import org.sonar.python.tree.SliceItemImpl;
import org.sonar.python.tree.SliceListImpl;
import org.sonar.python.tree.StarredExpressionImpl;
import org.sonar.python.tree.StatementListImpl;
import org.sonar.python.tree.StringElementImpl;
import org.sonar.python.tree.StringLiteralImpl;
import org.sonar.python.tree.SubscriptionExpressionImpl;
import org.sonar.python.tree.TokenImpl;
import org.sonar.python.tree.TryStatementImpl;
import org.sonar.python.tree.TupleImpl;
import org.sonar.python.tree.TupleParameterImpl;
import org.sonar.python.tree.TypeAnnotationImpl;
import org.sonar.python.tree.UnaryExpressionImpl;
import org.sonar.python.tree.WhileStatementImpl;
import org.sonar.python.tree.WithStatementImpl;
import org.sonar.python.tree.YieldExpressionImpl;
import org.sonar.python.tree.YieldStatementImpl;

public class PythonTreeMaker {
    public FileInput fileInput(AstNode astNode) {
        List<Statement> statements = PythonTreeMaker.getStatements(astNode).stream().map(this::statement).collect(Collectors.toList());
        StatementListImpl statementList = statements.isEmpty() ? null : new StatementListImpl(astNode, statements, PythonTreeMaker.toPyToken(astNode.getTokens()));
        FileInputImpl pyFileInputTree = new FileInputImpl(astNode, statementList, PythonTreeMaker.toPyToken(DocstringExtractor.extractDocstring(astNode)));
        this.setParents(pyFileInputTree);
        return pyFileInputTree;
    }

    private static org.sonar.python.api.tree.Token toPyToken(@Nullable Token token) {
        if (token == null) {
            return null;
        }
        return new TokenImpl(token);
    }

    private static List<org.sonar.python.api.tree.Token> toPyToken(List<Token> tokens) {
        return tokens.stream().map(TokenImpl::new).collect(Collectors.toList());
    }

    public void setParents(Tree root) {
        for (Tree child : root.children()) {
            if (child == null) continue;
            ((PyTree)child).setParent(root);
            this.setParents(child);
        }
    }

    Statement statement(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{PythonGrammar.IF_STMT})) {
            return this.ifStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.PASS_STMT})) {
            return this.passStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.PRINT_STMT})) {
            return this.printStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.EXEC_STMT})) {
            return this.execStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ASSERT_STMT})) {
            return this.assertStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.DEL_STMT})) {
            return this.delStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.RETURN_STMT})) {
            return this.returnStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.YIELD_STMT})) {
            return this.yieldStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.RAISE_STMT})) {
            return this.raiseStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.BREAK_STMT})) {
            return this.breakStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.CONTINUE_STMT})) {
            return this.continueStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.FUNCDEF})) {
            return this.funcDefStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.CLASSDEF})) {
            return this.classDefStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.IMPORT_STMT})) {
            return this.importStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.FOR_STMT})) {
            return this.forStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.WHILE_STMT})) {
            return this.whileStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.GLOBAL_STMT})) {
            return this.globalStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.NONLOCAL_STMT})) {
            return this.nonlocalStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.EXPRESSION_STMT}) && astNode.hasDirectChildren(new AstNodeType[]{PythonGrammar.ANNASSIGN})) {
            return this.annotatedAssignment(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.EXPRESSION_STMT}) && astNode.hasDirectChildren(new AstNodeType[]{PythonPunctuator.ASSIGN})) {
            return this.assignment(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.EXPRESSION_STMT}) && astNode.hasDirectChildren(new AstNodeType[]{PythonGrammar.AUGASSIGN})) {
            return this.compoundAssignment(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.EXPRESSION_STMT})) {
            return this.expressionStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.TRY_STMT})) {
            return this.tryStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ASYNC_STMT}) && astNode.hasDirectChildren(new AstNodeType[]{PythonGrammar.FOR_STMT})) {
            return this.forStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ASYNC_STMT}) && astNode.hasDirectChildren(new AstNodeType[]{PythonGrammar.WITH_STMT})) {
            return this.withStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.WITH_STMT})) {
            return this.withStatement(astNode);
        }
        throw new IllegalStateException("Statement " + astNode.getType() + " not correctly translated to strongly typed AST");
    }

    public AnnotatedAssignment annotatedAssignment(AstNode astNode) {
        AstNode annAssign = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.ANNASSIGN});
        AstNode colonTokenNode = annAssign.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON});
        Expression variable = this.exprListOrTestList(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST_STAR_EXPR}));
        Expression annotation = this.expression(annAssign.getFirstChild(new AstNodeType[]{PythonGrammar.TEST}));
        AstNode equalTokenNode = annAssign.getFirstChild(new AstNodeType[]{PythonPunctuator.ASSIGN});
        org.sonar.python.api.tree.Token equalToken = null;
        Expression assignedValue = null;
        if (equalTokenNode != null) {
            equalToken = PythonTreeMaker.toPyToken(equalTokenNode.getToken());
            assignedValue = this.expression(equalTokenNode.getNextSibling());
        }
        return new AnnotatedAssignmentImpl(variable, PythonTreeMaker.toPyToken(colonTokenNode.getToken()), annotation, equalToken, assignedValue);
    }

    private StatementList getStatementListFromSuite(AstNode suite) {
        return new StatementListImpl(suite, this.getStatementsFromSuite(suite), PythonTreeMaker.toPyToken(suite.getTokens()));
    }

    private List<Statement> getStatementsFromSuite(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{PythonGrammar.SUITE})) {
            List<AstNode> statements = PythonTreeMaker.getStatements(astNode);
            if (statements.isEmpty()) {
                AstNode stmtListNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.STMT_LIST});
                return stmtListNode.getChildren(new AstNodeType[]{PythonGrammar.SIMPLE_STMT}).stream().map(AstNode::getFirstChild).map(this::statement).collect(Collectors.toList());
            }
            return statements.stream().map(this::statement).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static List<AstNode> getStatements(AstNode astNode) {
        List statements = astNode.getChildren(new AstNodeType[]{PythonGrammar.STATEMENT});
        return statements.stream().flatMap(stmt -> {
            if (stmt.hasDirectChildren(new AstNodeType[]{PythonGrammar.STMT_LIST})) {
                AstNode stmtListNode = stmt.getFirstChild(new AstNodeType[]{PythonGrammar.STMT_LIST});
                return stmtListNode.getChildren(new AstNodeType[]{PythonGrammar.SIMPLE_STMT}).stream().map(AstNode::getFirstChild);
            }
            return stmt.getChildren(new AstNodeType[]{PythonGrammar.COMPOUND_STMT}).stream().map(AstNode::getFirstChild);
        }).collect(Collectors.toList());
    }

    public PrintStatement printStatement(AstNode astNode) {
        List<Expression> expressions = this.expressionsFromTest(astNode);
        return new PrintStatementImpl(astNode, PythonTreeMaker.toPyToken(astNode.getTokens()).get(0), expressions);
    }

    public ExecStatement execStatement(AstNode astNode) {
        Expression expression = this.expression(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.EXPR}));
        List<Expression> expressions = this.expressionsFromTest(astNode);
        if (expressions.isEmpty()) {
            return new ExecStatementImpl(astNode, PythonTreeMaker.toPyToken(astNode.getTokens()).get(0), expression);
        }
        return new ExecStatementImpl(astNode, PythonTreeMaker.toPyToken((Token)astNode.getTokens().get(0)), expression, expressions.get(0), expressions.size() == 2 ? expressions.get(1) : null);
    }

    public AssertStatement assertStatement(AstNode astNode) {
        List<Expression> expressions = this.expressionsFromTest(astNode);
        Expression condition = expressions.get(0);
        Expression message = null;
        if (expressions.size() > 1) {
            message = expressions.get(1);
        }
        return new AssertStatementImpl(astNode, PythonTreeMaker.toPyToken(astNode.getTokens()).get(0), condition, message);
    }

    public PassStatement passStatement(AstNode astNode) {
        return new PassStatementImpl(astNode, PythonTreeMaker.toPyToken(astNode.getTokens()).get(0));
    }

    public DelStatement delStatement(AstNode astNode) {
        List<Expression> expressionTrees = this.expressionsFromExprList(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.EXPRLIST}));
        return new DelStatementImpl(astNode, PythonTreeMaker.toPyToken(astNode.getTokens()).get(0), expressionTrees);
    }

    public ReturnStatement returnStatement(AstNode astNode) {
        AstNode testListNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST});
        List<Expression> expressionTrees = Collections.emptyList();
        if (testListNode != null) {
            expressionTrees = this.expressionsFromTest(testListNode);
        }
        return new ReturnStatementImpl(astNode, PythonTreeMaker.toPyToken(astNode.getTokens()).get(0), expressionTrees);
    }

    public YieldStatement yieldStatement(AstNode astNode) {
        return new YieldStatementImpl(astNode, this.yieldExpression(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.YIELD_EXPR})));
    }

    public YieldExpression yieldExpression(AstNode astNode) {
        org.sonar.python.api.tree.Token yieldKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.YIELD}).getToken());
        AstNode nodeContainingExpression = astNode;
        AstNode fromKeyword = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.FROM});
        if (fromKeyword == null) {
            nodeContainingExpression = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST});
        }
        List<Expression> expressionTrees = Collections.emptyList();
        if (nodeContainingExpression != null) {
            expressionTrees = this.expressionsFromTest(nodeContainingExpression);
        }
        return new YieldExpressionImpl(astNode, yieldKeyword, fromKeyword == null ? null : PythonTreeMaker.toPyToken(fromKeyword.getToken()), expressionTrees);
    }

    public RaiseStatement raiseStatement(AstNode astNode) {
        AstNode fromKeyword = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.FROM});
        List expressions = new ArrayList<AstNode>();
        AstNode fromExpression = null;
        if (fromKeyword != null) {
            expressions.add(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TEST}));
            fromExpression = astNode.getLastChild(new AstNodeType[]{PythonGrammar.TEST});
        } else {
            expressions = astNode.getChildren(new AstNodeType[]{PythonGrammar.TEST});
        }
        List<Expression> expressionTrees = expressions.stream().map(this::expression).collect(Collectors.toList());
        return new RaiseStatementImpl(astNode, PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.RAISE}).getToken()), expressionTrees, fromKeyword == null ? null : PythonTreeMaker.toPyToken(fromKeyword.getToken()), fromExpression == null ? null : this.expression(fromExpression));
    }

    public BreakStatement breakStatement(AstNode astNode) {
        return new BreakStatementImpl(astNode, PythonTreeMaker.toPyToken(astNode.getToken()));
    }

    public ContinueStatement continueStatement(AstNode astNode) {
        return new ContinueStatementImpl(astNode, PythonTreeMaker.toPyToken(astNode.getToken()));
    }

    public ImportStatement importStatement(AstNode astNode) {
        AstNode importStmt = astNode.getFirstChild();
        if (importStmt.is(new AstNodeType[]{PythonGrammar.IMPORT_NAME})) {
            return this.importName(importStmt);
        }
        return this.importFromStatement(importStmt);
    }

    private ImportName importName(AstNode astNode) {
        org.sonar.python.api.tree.Token importKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.IMPORT}).getToken());
        List<AliasedName> aliasedNames = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.DOTTED_AS_NAMES}).getChildren(new AstNodeType[]{PythonGrammar.DOTTED_AS_NAME}).stream().map(this::aliasedName).collect(Collectors.toList());
        return new ImportNameImpl(astNode, importKeyword, aliasedNames);
    }

    public ImportFrom importFromStatement(AstNode astNode) {
        org.sonar.python.api.tree.Token importKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.IMPORT}).getToken());
        org.sonar.python.api.tree.Token fromKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.FROM}).getToken());
        List<org.sonar.python.api.tree.Token> dottedPrefixForModule = PythonTreeMaker.toPyToken(astNode.getChildren(new AstNodeType[]{PythonPunctuator.DOT}).stream().map(AstNode::getToken).collect(Collectors.toList()));
        AstNode moduleNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.DOTTED_NAME});
        DottedName moduleName = null;
        if (moduleNode != null) {
            moduleName = PythonTreeMaker.dottedName(moduleNode);
        }
        AstNode importAsnames = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.IMPORT_AS_NAMES});
        List aliasedImportNames = null;
        boolean isWildcardImport = true;
        if (importAsnames != null) {
            aliasedImportNames = importAsnames.getChildren(new AstNodeType[]{PythonGrammar.IMPORT_AS_NAME}).stream().map(this::aliasedName).collect(Collectors.toList());
            isWildcardImport = false;
        }
        return new ImportFromImpl(astNode, fromKeyword, dottedPrefixForModule, moduleName, importKeyword, aliasedImportNames, isWildcardImport);
    }

    private AliasedName aliasedName(AstNode astNode) {
        DottedName dottedName;
        AstNode asKeyword = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.AS});
        if (astNode.is(new AstNodeType[]{PythonGrammar.DOTTED_AS_NAME})) {
            dottedName = PythonTreeMaker.dottedName(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.DOTTED_NAME}));
        } else {
            AstNode importedName = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.NAME});
            dottedName = new DottedNameImpl(astNode, Collections.singletonList(PythonTreeMaker.name(importedName)));
        }
        if (asKeyword == null) {
            return new AliasedNameImpl(astNode, null, dottedName, null);
        }
        return new AliasedNameImpl(astNode, PythonTreeMaker.toPyToken(asKeyword.getToken()), dottedName, PythonTreeMaker.name(astNode.getLastChild(new AstNodeType[]{PythonGrammar.NAME})));
    }

    private static DottedName dottedName(AstNode astNode) {
        List<Name> names = astNode.getChildren(new AstNodeType[]{PythonGrammar.NAME}).stream().map(PythonTreeMaker::name).collect(Collectors.toList());
        return new DottedNameImpl(astNode, names);
    }

    public GlobalStatement globalStatement(AstNode astNode) {
        org.sonar.python.api.tree.Token globalKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.GLOBAL}).getToken());
        List<Name> variables = astNode.getChildren(new AstNodeType[]{PythonGrammar.NAME}).stream().map(PythonTreeMaker::name).collect(Collectors.toList());
        return new GlobalStatementImpl(astNode, globalKeyword, variables);
    }

    public NonlocalStatement nonlocalStatement(AstNode astNode) {
        org.sonar.python.api.tree.Token nonlocalKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.NONLOCAL}).getToken());
        List<Name> variables = astNode.getChildren(new AstNodeType[]{PythonGrammar.NAME}).stream().map(PythonTreeMaker::name).collect(Collectors.toList());
        return new NonlocalStatementImpl(astNode, nonlocalKeyword, variables);
    }

    public IfStatement ifStatement(AstNode astNode) {
        org.sonar.python.api.tree.Token ifToken = PythonTreeMaker.toPyToken((Token)astNode.getTokens().get(0));
        AstNode condition = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TEST});
        AstNode suite = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE});
        StatementList statements = this.getStatementListFromSuite(suite);
        AstNode elseSuite = astNode.getLastChild(new AstNodeType[]{PythonGrammar.SUITE});
        ElseStatement elseStatement = null;
        if (elseSuite.getPreviousSibling().getPreviousSibling().is(new AstNodeType[]{PythonKeyword.ELSE})) {
            elseStatement = this.elseStatement(elseSuite);
        }
        List<IfStatement> elifBranches = astNode.getChildren(new AstNodeType[]{PythonKeyword.ELIF}).stream().map(this::elifStatement).collect(Collectors.toList());
        return new IfStatementImpl(ifToken, this.expression(condition), statements, elifBranches, elseStatement);
    }

    private IfStatement elifStatement(AstNode astNode) {
        org.sonar.python.api.tree.Token elifToken = PythonTreeMaker.toPyToken(astNode.getToken());
        AstNode suite = astNode.getNextSibling().getNextSibling().getNextSibling();
        AstNode condition = astNode.getNextSibling();
        StatementList statements = this.getStatementListFromSuite(suite);
        return new IfStatementImpl(elifToken, this.expression(condition), statements);
    }

    private ElseStatement elseStatement(AstNode astNode) {
        org.sonar.python.api.tree.Token elseToken = PythonTreeMaker.toPyToken(astNode.getPreviousSibling().getPreviousSibling().getToken());
        StatementList statements = this.getStatementListFromSuite(astNode);
        return new ElseStatementImpl(elseToken, statements);
    }

    public FunctionDef funcDefStatement(AstNode astNode) {
        AstNode decoratorsNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.DECORATORS});
        List<Decorator> decorators = Collections.emptyList();
        if (decoratorsNode != null) {
            decorators = decoratorsNode.getChildren(new AstNodeType[]{PythonGrammar.DECORATOR}).stream().map(this::decorator).collect(Collectors.toList());
        }
        Name name = PythonTreeMaker.name(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}).getFirstChild(new AstNodeType[]{PythonGrammar.NAME}));
        ParameterListImpl parameterList = null;
        AstNode typedArgListNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TYPEDARGSLIST});
        if (typedArgListNode != null) {
            List<AnyParameter> arguments = typedArgListNode.getChildren(new AstNodeType[]{PythonGrammar.TFPDEF}).stream().map(this::parameter).collect(Collectors.toList());
            parameterList = new ParameterListImpl(typedArgListNode, arguments);
        }
        StatementList body = this.getStatementListFromSuite(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE}));
        AstNode defNode = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.DEF});
        org.sonar.python.api.tree.Token asyncToken = null;
        AstNode defPreviousSibling = defNode.getPreviousSibling();
        if (defPreviousSibling != null && defPreviousSibling.getToken().getValue().equals("async")) {
            asyncToken = PythonTreeMaker.toPyToken(defPreviousSibling.getToken());
        }
        org.sonar.python.api.tree.Token lPar = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.LPARENTHESIS}).getToken());
        org.sonar.python.api.tree.Token rPar = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.RPARENTHESIS}).getToken());
        TypeAnnotationImpl returnType = null;
        AstNode returnTypeNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.FUN_RETURN_ANNOTATION});
        if (returnTypeNode != null) {
            List children = returnTypeNode.getChildren();
            returnType = new TypeAnnotationImpl(PythonTreeMaker.toPyToken(((AstNode)children.get(0)).getToken()), PythonTreeMaker.toPyToken(((AstNode)children.get(1)).getToken()), this.expression((AstNode)children.get(2)));
        }
        org.sonar.python.api.tree.Token colon = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON}).getToken());
        return new FunctionDefImpl(astNode, decorators, asyncToken, PythonTreeMaker.toPyToken(defNode.getToken()), name, lPar, parameterList, rPar, returnType, colon, body, PythonTreeMaker.isMethodDefinition(astNode), PythonTreeMaker.toPyToken(DocstringExtractor.extractDocstring(astNode)));
    }

    private Decorator decorator(AstNode astNode) {
        org.sonar.python.api.tree.Token atToken = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.AT}).getToken());
        DottedName dottedName = PythonTreeMaker.dottedName(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.DOTTED_NAME}));
        org.sonar.python.api.tree.Token lPar = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.LPARENTHESIS}) == null ? null : PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.LPARENTHESIS}).getToken());
        org.sonar.python.api.tree.Token rPar = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.RPARENTHESIS}) == null ? null : PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.RPARENTHESIS}).getToken());
        ArgList argListTree = this.argList(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.ARGLIST}));
        return new DecoratorImpl(astNode, atToken, dottedName, lPar, argListTree, rPar);
    }

    private static boolean isMethodDefinition(AstNode node) {
        AstNode parent;
        for (parent = node.getParent(); parent != null && !parent.is(new AstNodeType[]{PythonGrammar.CLASSDEF, PythonGrammar.FUNCDEF}); parent = parent.getParent()) {
        }
        return parent != null && parent.is(new AstNodeType[]{PythonGrammar.CLASSDEF});
    }

    public ClassDef classDefStatement(AstNode astNode) {
        AstNode decoratorsNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.DECORATORS});
        List<Decorator> decorators = Collections.emptyList();
        if (decoratorsNode != null) {
            decorators = decoratorsNode.getChildren(new AstNodeType[]{PythonGrammar.DECORATOR}).stream().map(this::decorator).collect(Collectors.toList());
        }
        Name name = PythonTreeMaker.name(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.CLASSNAME}).getFirstChild(new AstNodeType[]{PythonGrammar.NAME}));
        ArgList args = null;
        AstNode leftPar = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.LPARENTHESIS});
        if (leftPar != null) {
            args = this.argList(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.ARGLIST}));
        }
        StatementList body = this.getStatementListFromSuite(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE}));
        org.sonar.python.api.tree.Token classToken = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.CLASS}).getToken());
        AstNode rightPar = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.RPARENTHESIS});
        org.sonar.python.api.tree.Token colon = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON}).getToken());
        return new ClassDefImpl(astNode, decorators, classToken, name, leftPar != null ? PythonTreeMaker.toPyToken(leftPar.getToken()) : null, args, rightPar != null ? PythonTreeMaker.toPyToken(rightPar.getToken()) : null, colon, body, PythonTreeMaker.toPyToken(DocstringExtractor.extractDocstring(astNode)));
    }

    private static Name name(AstNode astNode) {
        return new NameImpl(astNode, astNode.getFirstChild(new AstNodeType[]{GenericTokenType.IDENTIFIER}).getTokenOriginalValue(), astNode.getParent().is(new AstNodeType[]{PythonGrammar.ATOM}));
    }

    public ForStatement forStatement(AstNode astNode) {
        AstNode forStatementNode = astNode;
        org.sonar.python.api.tree.Token asyncToken = null;
        if (astNode.is(new AstNodeType[]{PythonGrammar.ASYNC_STMT})) {
            asyncToken = PythonTreeMaker.toPyToken(astNode.getFirstChild().getToken());
            forStatementNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.FOR_STMT});
        }
        org.sonar.python.api.tree.Token forKeyword = PythonTreeMaker.toPyToken(forStatementNode.getFirstChild(new AstNodeType[]{PythonKeyword.FOR}).getToken());
        org.sonar.python.api.tree.Token inKeyword = PythonTreeMaker.toPyToken(forStatementNode.getFirstChild(new AstNodeType[]{PythonKeyword.IN}).getToken());
        org.sonar.python.api.tree.Token colon = PythonTreeMaker.toPyToken(forStatementNode.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON}).getToken());
        List<Expression> expressions = this.expressionsFromExprList(forStatementNode.getFirstChild(new AstNodeType[]{PythonGrammar.EXPRLIST}));
        List<Expression> testExpressions = this.expressionsFromTest(forStatementNode.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST}));
        AstNode firstSuite = forStatementNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE});
        StatementList body = this.getStatementListFromSuite(firstSuite);
        AstNode lastSuite = forStatementNode.getLastChild(new AstNodeType[]{PythonGrammar.SUITE});
        AstNode elseKeywordNode = forStatementNode.getFirstChild(new AstNodeType[]{PythonKeyword.ELSE});
        org.sonar.python.api.tree.Token elseKeyword = null;
        org.sonar.python.api.tree.Token elseColonKeyword = null;
        if (elseKeywordNode != null) {
            elseKeyword = PythonTreeMaker.toPyToken(elseKeywordNode.getToken());
            elseColonKeyword = PythonTreeMaker.toPyToken(elseKeywordNode.getNextSibling().getToken());
        }
        StatementList elseBody = lastSuite == firstSuite ? null : this.getStatementListFromSuite(lastSuite);
        return new ForStatementImpl(forStatementNode, forKeyword, expressions, inKeyword, testExpressions, colon, body, elseKeyword, elseColonKeyword, elseBody, asyncToken);
    }

    public WhileStatementImpl whileStatement(AstNode astNode) {
        org.sonar.python.api.tree.Token whileKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.WHILE}).getToken());
        org.sonar.python.api.tree.Token colon = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON}).getToken());
        Expression condition = this.expression(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TEST}));
        AstNode firstSuite = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE});
        StatementList body = this.getStatementListFromSuite(firstSuite);
        AstNode lastSuite = astNode.getLastChild(new AstNodeType[]{PythonGrammar.SUITE});
        AstNode elseKeywordNode = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.ELSE});
        org.sonar.python.api.tree.Token elseKeyword = null;
        org.sonar.python.api.tree.Token elseColonKeyword = null;
        if (elseKeywordNode != null) {
            elseKeyword = PythonTreeMaker.toPyToken(elseKeywordNode.getToken());
            elseColonKeyword = PythonTreeMaker.toPyToken(elseKeywordNode.getNextSibling().getToken());
        }
        StatementList elseBody = lastSuite == firstSuite ? null : this.getStatementListFromSuite(lastSuite);
        return new WhileStatementImpl(astNode, whileKeyword, condition, colon, body, elseKeyword, elseColonKeyword, elseBody);
    }

    public ExpressionStatement expressionStatement(AstNode astNode) {
        List<Expression> expressions = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST_STAR_EXPR}).getChildren(new AstNodeType[]{PythonGrammar.TEST, PythonGrammar.STAR_EXPR}).stream().map(this::expression).collect(Collectors.toList());
        return new ExpressionStatementImpl(astNode, expressions);
    }

    public AssignmentStatement assignment(AstNode astNode) {
        ArrayList<org.sonar.python.api.tree.Token> assignTokens = new ArrayList<org.sonar.python.api.tree.Token>();
        ArrayList<ExpressionList> lhsExpressions = new ArrayList<ExpressionList>();
        List assignNodes = astNode.getChildren(new AstNodeType[]{PythonPunctuator.ASSIGN});
        for (AstNode assignNode : assignNodes) {
            assignTokens.add(PythonTreeMaker.toPyToken(assignNode.getToken()));
            lhsExpressions.add(this.expressionList(assignNode.getPreviousSibling()));
        }
        AstNode assignedValueNode = ((AstNode)assignNodes.get(assignNodes.size() - 1)).getNextSibling();
        Expression assignedValue = assignedValueNode.is(new AstNodeType[]{PythonGrammar.YIELD_EXPR}) ? this.yieldExpression(assignedValueNode) : this.exprListOrTestList(assignedValueNode);
        return new AssignmentStatementImpl(astNode, assignTokens, lhsExpressions, assignedValue);
    }

    public CompoundAssignmentStatement compoundAssignment(AstNode astNode) {
        AstNode augAssignNodes = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.AUGASSIGN});
        Expression lhsExpression = this.exprListOrTestList(augAssignNodes.getPreviousSibling());
        AstNode rhsAstNode = augAssignNodes.getNextSibling();
        Expression rhsExpression = rhsAstNode.is(new AstNodeType[]{PythonGrammar.YIELD_EXPR}) ? this.yieldExpression(rhsAstNode) : this.exprListOrTestList(rhsAstNode);
        return new CompoundAssignmentStatementImpl(astNode, lhsExpression, PythonTreeMaker.toPyToken(augAssignNodes.getToken()), rhsExpression);
    }

    private ExpressionList expressionList(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{PythonGrammar.TESTLIST_STAR_EXPR, PythonGrammar.TESTLIST_COMP})) {
            List<Expression> expressions = astNode.getChildren(new AstNodeType[]{PythonGrammar.TEST, PythonGrammar.STAR_EXPR}).stream().map(this::expression).collect(Collectors.toList());
            return new ExpressionListImpl(astNode, expressions);
        }
        return new ExpressionListImpl(astNode, Collections.singletonList(this.expression(astNode)));
    }

    public TryStatement tryStatement(AstNode astNode) {
        org.sonar.python.api.tree.Token tryKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.TRY}).getToken());
        StatementList tryBody = this.getStatementListFromSuite(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE}));
        List<ExceptClause> exceptClauseTrees = astNode.getChildren(new AstNodeType[]{PythonGrammar.EXCEPT_CLAUSE}).stream().map(except -> {
            AstNode suite = except.getNextSibling().getNextSibling();
            return this.exceptClause((AstNode)except, this.getStatementListFromSuite(suite));
        }).collect(Collectors.toList());
        FinallyClauseImpl finallyClause = null;
        AstNode finallyNode = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.FINALLY});
        if (finallyNode != null) {
            AstNode finallySuite = finallyNode.getNextSibling().getNextSibling();
            StatementList body = this.getStatementListFromSuite(finallySuite);
            finallyClause = new FinallyClauseImpl(PythonTreeMaker.toPyToken(finallyNode.getToken()), body);
        }
        ElseStatement elseStatementTree = null;
        AstNode elseNode = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.ELSE});
        if (elseNode != null) {
            elseStatementTree = this.elseStatement(elseNode.getNextSibling().getNextSibling());
        }
        return new TryStatementImpl(astNode, tryKeyword, tryBody, exceptClauseTrees, finallyClause, elseStatementTree);
    }

    public WithStatement withStatement(AstNode astNode) {
        AstNode withStmtNode = astNode;
        org.sonar.python.api.tree.Token asyncKeyword = null;
        if (astNode.is(new AstNodeType[]{PythonGrammar.ASYNC_STMT})) {
            withStmtNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.WITH_STMT});
            asyncKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild().getToken());
        }
        List<WithItem> withItems = this.withItems(withStmtNode.getChildren(new AstNodeType[]{PythonGrammar.WITH_ITEM}));
        AstNode suite = withStmtNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE});
        org.sonar.python.api.tree.Token colon = PythonTreeMaker.toPyToken(suite.getPreviousSibling().getToken());
        StatementList statements = this.getStatementListFromSuite(suite);
        return new WithStatementImpl(withStmtNode, withItems, colon, statements, asyncKeyword);
    }

    private List<WithItem> withItems(List<AstNode> withItems) {
        return withItems.stream().map(this::withItem).collect(Collectors.toList());
    }

    private WithItem withItem(AstNode withItem) {
        AstNode testNode = withItem.getFirstChild(new AstNodeType[]{PythonGrammar.TEST});
        Expression test = this.expression(testNode);
        AstNode asNode = testNode.getNextSibling();
        Expression expr = null;
        org.sonar.python.api.tree.Token as = null;
        if (asNode != null) {
            as = PythonTreeMaker.toPyToken(asNode.getToken());
            expr = this.expression(withItem.getFirstChild(new AstNodeType[]{PythonGrammar.EXPR}));
        }
        return new WithStatementImpl.WithItemImpl(withItem, test, as, expr);
    }

    private ExceptClause exceptClause(AstNode except, StatementList body) {
        org.sonar.python.api.tree.Token exceptKeyword = PythonTreeMaker.toPyToken(except.getFirstChild(new AstNodeType[]{PythonKeyword.EXCEPT}).getToken());
        AstNode exceptionNode = except.getFirstChild(new AstNodeType[]{PythonGrammar.TEST});
        if (exceptionNode == null) {
            return new ExceptClauseImpl(exceptKeyword, body);
        }
        AstNode asNode = except.getFirstChild(new AstNodeType[]{PythonKeyword.AS});
        AstNode commaNode = except.getFirstChild(new AstNodeType[]{PythonPunctuator.COMMA});
        if (asNode != null || commaNode != null) {
            Expression exceptionInstance = this.expression(except.getLastChild(new AstNodeType[]{PythonGrammar.TEST}));
            org.sonar.python.api.tree.Token asNodeToken = asNode != null ? PythonTreeMaker.toPyToken(asNode.getToken()) : null;
            org.sonar.python.api.tree.Token commaNodeToken = commaNode != null ? PythonTreeMaker.toPyToken(commaNode.getToken()) : null;
            return new ExceptClauseImpl(exceptKeyword, body, this.expression(exceptionNode), asNodeToken, commaNodeToken, exceptionInstance);
        }
        return new ExceptClauseImpl(exceptKeyword, body, this.expression(exceptionNode));
    }

    private List<Expression> expressionsFromTest(AstNode astNode) {
        return astNode.getChildren(new AstNodeType[]{PythonGrammar.TEST}).stream().map(this::expression).collect(Collectors.toList());
    }

    private List<Expression> expressionsFromExprList(AstNode firstChild) {
        return firstChild.getChildren(new AstNodeType[]{PythonGrammar.EXPR, PythonGrammar.STAR_EXPR}).stream().map(this::expression).collect(Collectors.toList());
    }

    private Expression exprListOrTestList(AstNode exprListOrTestList) {
        List<Expression> expressions = exprListOrTestList.getChildren(new AstNodeType[]{PythonGrammar.EXPR, PythonGrammar.STAR_EXPR, PythonGrammar.TEST}).stream().map(this::expression).collect(Collectors.toList());
        List commas = exprListOrTestList.getChildren(new AstNodeType[]{PythonPunctuator.COMMA});
        if (commas.isEmpty()) {
            return (Expression)expressions.get(0);
        }
        List<org.sonar.python.api.tree.Token> commaTokens = PythonTreeMaker.toPyToken(commas.stream().map(AstNode::getToken).collect(Collectors.toList()));
        return new TupleImpl(exprListOrTestList, null, expressions, commaTokens, null);
    }

    Expression expression(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{PythonGrammar.ATOM}) && astNode.getFirstChild().is(new AstNodeType[]{PythonPunctuator.LBRACKET})) {
            return this.listLiteral(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ATOM}) && astNode.getFirstChild().is(new AstNodeType[]{PythonPunctuator.LPARENTHESIS})) {
            return this.parenthesized(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ATOM}) && astNode.getFirstChild().is(new AstNodeType[]{PythonPunctuator.LCURLYBRACE})) {
            return this.dictOrSetLiteral(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ATOM}) && astNode.getFirstChild().is(new AstNodeType[]{PythonPunctuator.BACKTICK})) {
            return this.repr(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ATOM}) && astNode.getFirstChild().is(new AstNodeType[]{PythonTokenType.STRING})) {
            return PythonTreeMaker.stringLiteral(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ATOM}) && astNode.getChildren().size() == 1) {
            return this.expression(astNode.getFirstChild());
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.TEST}) && astNode.hasDirectChildren(new AstNodeType[]{PythonKeyword.IF})) {
            return this.conditionalExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonTokenType.NUMBER})) {
            return PythonTreeMaker.numericLiteral(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.YIELD_EXPR})) {
            return this.yieldExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.NAME})) {
            return PythonTreeMaker.name(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ATTRIBUTE_REF})) {
            return this.qualifiedExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.CALL_EXPR})) {
            return this.callExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.EXPR, PythonGrammar.TEST, PythonGrammar.TEST_NOCOND})) {
            if (astNode.getChildren().size() == 1) {
                return this.expression(astNode.getFirstChild());
            }
            return this.binaryExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.A_EXPR, PythonGrammar.M_EXPR, PythonGrammar.SHIFT_EXPR, PythonGrammar.AND_EXPR, PythonGrammar.OR_EXPR, PythonGrammar.XOR_EXPR, PythonGrammar.AND_TEST, PythonGrammar.OR_TEST, PythonGrammar.COMPARISON})) {
            return this.binaryExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.POWER})) {
            return this.powerExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.LAMBDEF, PythonGrammar.LAMBDEF_NOCOND})) {
            return this.lambdaExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.FACTOR, PythonGrammar.NOT_TEST})) {
            return new UnaryExpressionImpl(astNode, PythonTreeMaker.toPyToken(astNode.getFirstChild().getToken()), this.expression(astNode.getLastChild()));
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.STAR_EXPR})) {
            return new StarredExpressionImpl(astNode, PythonTreeMaker.toPyToken(astNode.getToken()), this.expression(astNode.getLastChild()));
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.SUBSCRIPTION_OR_SLICING})) {
            Expression baseExpr = this.expression(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.ATOM}));
            org.sonar.python.api.tree.Token leftBracket = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.LBRACKET}).getToken());
            org.sonar.python.api.tree.Token rightBracket = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.RBRACKET}).getToken());
            return this.subscriptionOrSlicing(baseExpr, leftBracket, astNode, rightBracket);
        }
        if (astNode.is(new AstNodeType[]{PythonKeyword.NONE})) {
            return new NoneExpressionImpl(astNode, PythonTreeMaker.toPyToken(astNode.getToken()));
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ELLIPSIS})) {
            return new EllipsisExpressionImpl(astNode);
        }
        throw new IllegalStateException("Expression " + astNode.getType() + " not correctly translated to strongly typed AST");
    }

    private Expression repr(AstNode astNode) {
        org.sonar.python.api.tree.Token openingBacktick = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.BACKTICK}).getToken());
        org.sonar.python.api.tree.Token closingBacktick = PythonTreeMaker.toPyToken(astNode.getLastChild(new AstNodeType[]{PythonPunctuator.BACKTICK}).getToken());
        List<Expression> expressions = astNode.getChildren(new AstNodeType[]{PythonGrammar.TEST}).stream().map(this::expression).collect(Collectors.toList());
        ExpressionListImpl expressionListTree = new ExpressionListImpl(expressions);
        return new ReprExpressionImpl(astNode, openingBacktick, expressionListTree, closingBacktick);
    }

    private Expression dictOrSetLiteral(AstNode astNode) {
        org.sonar.python.api.tree.Token lCurlyBrace = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.LCURLYBRACE}).getToken());
        org.sonar.python.api.tree.Token rCurlyBrace = PythonTreeMaker.toPyToken(astNode.getLastChild(new AstNodeType[]{PythonPunctuator.RCURLYBRACE}).getToken());
        AstNode dictOrSetMaker = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.DICTORSETMAKER});
        if (dictOrSetMaker == null) {
            return new DictionaryLiteralImpl(astNode, lCurlyBrace, Collections.emptyList(), Collections.emptyList(), rCurlyBrace);
        }
        AstNode compForNode = dictOrSetMaker.getFirstChild(new AstNodeType[]{PythonGrammar.COMP_FOR});
        if (compForNode != null) {
            ComprehensionFor compFor = this.compFor(compForNode);
            AstNode colon = dictOrSetMaker.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON});
            if (colon != null) {
                Expression keyExpression = this.expression(dictOrSetMaker.getFirstChild(new AstNodeType[]{PythonGrammar.TEST}));
                Expression valueExpression = this.expression(dictOrSetMaker.getLastChild(new AstNodeType[]{PythonGrammar.TEST}));
                return new DictCompExpressionImpl(lCurlyBrace, keyExpression, PythonTreeMaker.toPyToken(colon.getToken()), valueExpression, compFor, rCurlyBrace);
            }
            Expression resultExpression = this.expression(dictOrSetMaker.getFirstChild(new AstNodeType[]{PythonGrammar.TEST, PythonGrammar.STAR_EXPR}));
            return new ComprehensionExpressionImpl(Tree.Kind.SET_COMPREHENSION, lCurlyBrace, resultExpression, compFor, rCurlyBrace);
        }
        List<org.sonar.python.api.tree.Token> commas = PythonTreeMaker.toPyToken(dictOrSetMaker.getChildren(new AstNodeType[]{PythonPunctuator.COMMA}).stream().map(AstNode::getToken).collect(Collectors.toList()));
        if (dictOrSetMaker.hasDirectChildren(new AstNodeType[]{PythonPunctuator.COLON}) || dictOrSetMaker.hasDirectChildren(new AstNodeType[]{PythonPunctuator.MUL_MUL})) {
            ArrayList<KeyValuePair> keyValuePairTrees = new ArrayList<KeyValuePair>();
            List children = dictOrSetMaker.getChildren();
            int index = 0;
            while (index < children.size()) {
                AstNode currentChild = (AstNode)children.get(index);
                if (currentChild.is(new AstNodeType[]{PythonPunctuator.MUL_MUL})) {
                    keyValuePairTrees.add(new KeyValuePairImpl(PythonTreeMaker.toPyToken(currentChild.getToken()), this.expression((AstNode)children.get(index + 1))));
                    index += 3;
                    continue;
                }
                keyValuePairTrees.add(new KeyValuePairImpl(this.expression(currentChild), PythonTreeMaker.toPyToken(((AstNode)children.get(index + 1)).getToken()), this.expression((AstNode)children.get(index + 2))));
                index += 4;
            }
            return new DictionaryLiteralImpl(astNode, lCurlyBrace, commas, keyValuePairTrees, rCurlyBrace);
        }
        List<Expression> expressions = dictOrSetMaker.getChildren(new AstNodeType[]{PythonGrammar.TEST, PythonGrammar.STAR_EXPR}).stream().map(this::expression).collect(Collectors.toList());
        return new SetLiteralImpl(astNode, lCurlyBrace, expressions, commas, rCurlyBrace);
    }

    private Expression parenthesized(AstNode atom) {
        org.sonar.python.api.tree.Token lPar = PythonTreeMaker.toPyToken(atom.getFirstChild().getToken());
        org.sonar.python.api.tree.Token rPar = PythonTreeMaker.toPyToken(atom.getLastChild().getToken());
        AstNode yieldNode = atom.getFirstChild(new AstNodeType[]{PythonGrammar.YIELD_EXPR});
        if (yieldNode != null) {
            return new ParenthesizedExpressionImpl(lPar, this.expression(yieldNode), rPar);
        }
        AstNode testListComp = atom.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST_COMP});
        if (testListComp == null) {
            return new TupleImpl(atom, lPar, Collections.emptyList(), Collections.emptyList(), rPar);
        }
        AstNode compFor = testListComp.getFirstChild(new AstNodeType[]{PythonGrammar.COMP_FOR});
        if (compFor != null) {
            return new ComprehensionExpressionImpl(Tree.Kind.GENERATOR_EXPR, lPar, this.expression(testListComp.getFirstChild()), this.compFor(compFor), rPar);
        }
        ExpressionList expressionList = this.expressionList(testListComp);
        List commas = testListComp.getChildren(new AstNodeType[]{PythonPunctuator.COMMA});
        if (commas.isEmpty()) {
            Expression expression = expressionList.expressions().get(0);
            return new ParenthesizedExpressionImpl(lPar, expression, rPar);
        }
        List<org.sonar.python.api.tree.Token> commaTokens = PythonTreeMaker.toPyToken(commas.stream().map(AstNode::getToken).collect(Collectors.toList()));
        return new TupleImpl(atom, lPar, expressionList.expressions(), commaTokens, rPar);
    }

    private ConditionalExpression conditionalExpression(AstNode astNode) {
        List children = astNode.getChildren();
        Expression trueExpression = this.expression((AstNode)children.get(0));
        org.sonar.python.api.tree.Token ifToken = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.IF}).getToken());
        Expression condition = this.expression((AstNode)children.get(2));
        org.sonar.python.api.tree.Token elseToken = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.ELSE}).getToken());
        Expression falseExpression = this.expression((AstNode)children.get(4));
        return new ConditionalExpressionImpl(astNode, trueExpression, ifToken, condition, elseToken, falseExpression);
    }

    private Expression powerExpression(AstNode astNode) {
        AstNode powerOperator;
        Expression expr = this.expression(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.CALL_EXPR, PythonGrammar.ATTRIBUTE_REF, PythonGrammar.ATOM}));
        for (AstNode trailer : astNode.getChildren(new AstNodeType[]{PythonGrammar.TRAILER})) {
            expr = this.withTrailer(expr, trailer);
        }
        if (astNode.getFirstChild().is(new AstNodeType[]{GenericTokenType.IDENTIFIER})) {
            expr = new AwaitExpressionImpl(astNode, PythonTreeMaker.toPyToken(astNode.getFirstChild().getToken()), expr);
        }
        if ((powerOperator = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.MUL_MUL})) != null) {
            expr = new BinaryExpressionImpl(expr, PythonTreeMaker.toPyToken(powerOperator.getToken()), this.expression(powerOperator.getNextSibling()));
        }
        return expr;
    }

    private Expression withTrailer(Expression expr, AstNode trailer) {
        AstNode firstChild = trailer.getFirstChild();
        if (firstChild.is(new AstNodeType[]{PythonPunctuator.LPARENTHESIS})) {
            AstNode argListNode = trailer.getFirstChild(new AstNodeType[]{PythonGrammar.ARGLIST});
            org.sonar.python.api.tree.Token leftPar = PythonTreeMaker.toPyToken(firstChild.getToken());
            org.sonar.python.api.tree.Token rightPar = PythonTreeMaker.toPyToken(trailer.getFirstChild(new AstNodeType[]{PythonPunctuator.RPARENTHESIS}).getToken());
            return new CallExpressionImpl(expr, this.argList(argListNode), leftPar, rightPar);
        }
        if (firstChild.is(new AstNodeType[]{PythonPunctuator.LBRACKET})) {
            org.sonar.python.api.tree.Token leftBracket = PythonTreeMaker.toPyToken(trailer.getFirstChild(new AstNodeType[]{PythonPunctuator.LBRACKET}).getToken());
            org.sonar.python.api.tree.Token rightBracket = PythonTreeMaker.toPyToken(trailer.getFirstChild(new AstNodeType[]{PythonPunctuator.RBRACKET}).getToken());
            return this.subscriptionOrSlicing(expr, leftBracket, trailer.getFirstChild(new AstNodeType[]{PythonGrammar.SUBSCRIPTLIST}), rightBracket);
        }
        Name name = PythonTreeMaker.name(trailer.getFirstChild(new AstNodeType[]{PythonGrammar.NAME}));
        return new QualifiedExpressionImpl(trailer, name, expr, PythonTreeMaker.toPyToken(trailer.getFirstChild(new AstNodeType[]{PythonPunctuator.DOT}).getToken()));
    }

    private Expression subscriptionOrSlicing(Expression expr, org.sonar.python.api.tree.Token leftBracket, AstNode subscriptList, org.sonar.python.api.tree.Token rightBracket) {
        ArrayList<Tree> slices = new ArrayList<Tree>();
        for (AstNode subscript : subscriptList.getChildren(new AstNodeType[]{PythonGrammar.SUBSCRIPT})) {
            AstNode colon = subscript.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON});
            if (colon == null) {
                slices.add(this.expression(subscript.getFirstChild(new AstNodeType[]{PythonGrammar.TEST})));
                continue;
            }
            slices.add(this.sliceItem(subscript));
        }
        if (slices.stream().anyMatch(s -> Tree.Kind.SLICE_ITEM.equals((Object)s.getKind()))) {
            List<org.sonar.python.api.tree.Token> separators = PythonTreeMaker.toPyToken(subscriptList.getChildren(new AstNodeType[]{PythonPunctuator.COMMA}).stream().map(AstNode::getToken).collect(Collectors.toList()));
            SliceListImpl sliceList = new SliceListImpl(subscriptList, slices, separators);
            return new SliceExpressionImpl(expr, leftBracket, sliceList, rightBracket);
        }
        List<Expression> expressions = slices.stream().map(Expression.class::cast).collect(Collectors.toList());
        ExpressionListImpl subscripts = new ExpressionListImpl(expressions);
        return new SubscriptionExpressionImpl(expr, leftBracket, subscripts, rightBracket);
    }

    SliceItem sliceItem(AstNode subscript) {
        AstNode boundSeparator = subscript.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON});
        Expression lowerBound = this.sliceBound(boundSeparator.getPreviousSibling());
        Expression upperBound = this.sliceBound(boundSeparator.getNextSibling());
        AstNode strideNode = subscript.getFirstChild(new AstNodeType[]{PythonGrammar.SLICEOP});
        org.sonar.python.api.tree.Token strideSeparator = strideNode == null ? null : PythonTreeMaker.toPyToken(strideNode.getToken());
        Expression stride = null;
        if (strideNode != null && strideNode.hasDirectChildren(new AstNodeType[]{PythonGrammar.TEST})) {
            stride = this.expression(strideNode.getLastChild());
        }
        return new SliceItemImpl(subscript, lowerBound, PythonTreeMaker.toPyToken(boundSeparator.getToken()), upperBound, strideSeparator, stride);
    }

    @CheckForNull
    private Expression sliceBound(@Nullable AstNode node) {
        if (node == null || !node.is(new AstNodeType[]{PythonGrammar.TEST})) {
            return null;
        }
        return this.expression(node);
    }

    private Expression listLiteral(AstNode astNode) {
        ExpressionList elements;
        org.sonar.python.api.tree.Token leftBracket = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.LBRACKET}).getToken());
        org.sonar.python.api.tree.Token rightBracket = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.RBRACKET}).getToken());
        AstNode testListComp = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST_COMP});
        if (testListComp != null) {
            AstNode compForNode = testListComp.getFirstChild(new AstNodeType[]{PythonGrammar.COMP_FOR});
            if (compForNode != null) {
                Expression resultExpression = this.expression(testListComp.getFirstChild(new AstNodeType[]{PythonGrammar.TEST, PythonGrammar.STAR_EXPR}));
                return new ComprehensionExpressionImpl(Tree.Kind.LIST_COMPREHENSION, leftBracket, resultExpression, this.compFor(compForNode), rightBracket);
            }
            elements = this.expressionList(testListComp);
        } else {
            elements = new ExpressionListImpl(astNode, Collections.emptyList());
        }
        return new ListLiteralImpl(astNode, leftBracket, elements, rightBracket);
    }

    private ComprehensionFor compFor(AstNode compFor) {
        Expression expression = this.exprListOrTestList(compFor.getFirstChild(new AstNodeType[]{PythonGrammar.EXPRLIST}));
        org.sonar.python.api.tree.Token forToken = PythonTreeMaker.toPyToken(compFor.getFirstChild(new AstNodeType[]{PythonKeyword.FOR}).getToken());
        org.sonar.python.api.tree.Token inToken = PythonTreeMaker.toPyToken(compFor.getFirstChild(new AstNodeType[]{PythonKeyword.IN}).getToken());
        Expression iterable = this.exprListOrTestList(compFor.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST}));
        ComprehensionClause nested = this.compClause(compFor.getFirstChild(new AstNodeType[]{PythonGrammar.COMP_ITER}));
        return new ComprehensionForImpl(compFor, forToken, expression, inToken, iterable, nested);
    }

    @CheckForNull
    private ComprehensionClause compClause(@Nullable AstNode node) {
        if (node == null) {
            return null;
        }
        AstNode child = node.getFirstChild();
        if (child.is(new AstNodeType[]{PythonGrammar.COMP_FOR})) {
            return this.compFor(child);
        }
        Expression condition = this.expression(child.getFirstChild(new AstNodeType[]{PythonGrammar.TEST_NOCOND}));
        ComprehensionClause nestedClause = this.compClause(child.getFirstChild(new AstNodeType[]{PythonGrammar.COMP_ITER}));
        org.sonar.python.api.tree.Token ifToken = PythonTreeMaker.toPyToken(child.getFirstChild(new AstNodeType[]{PythonKeyword.IF}).getToken());
        return new ComprehensionIfImpl(child, ifToken, condition, nestedClause);
    }

    public QualifiedExpression qualifiedExpression(AstNode astNode) {
        Expression qualifier = this.expression(astNode.getFirstChild());
        List names = astNode.getChildren(new AstNodeType[]{PythonGrammar.NAME});
        AstNode lastNameNode = astNode.getLastChild();
        for (AstNode nameNode : names) {
            if (nameNode == lastNameNode) continue;
            qualifier = new QualifiedExpressionImpl(astNode, PythonTreeMaker.name(nameNode), qualifier, PythonTreeMaker.toPyToken(nameNode.getPreviousSibling().getToken()));
        }
        return new QualifiedExpressionImpl(astNode, PythonTreeMaker.name(lastNameNode), qualifier, PythonTreeMaker.toPyToken(lastNameNode.getPreviousSibling().getToken()));
    }

    public CallExpression callExpression(AstNode astNode) {
        Expression callee = this.expression(astNode.getFirstChild());
        AstNode argListNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.ARGLIST});
        ArgList argumentList = this.argList(argListNode);
        if (argumentList != null) {
            PythonTreeMaker.checkGeneratorExpressionInArgument(argumentList.arguments());
        }
        org.sonar.python.api.tree.Token leftPar = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.LPARENTHESIS}).getToken());
        org.sonar.python.api.tree.Token rightPar = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.RPARENTHESIS}).getToken());
        return new CallExpressionImpl(astNode, callee, argumentList, leftPar, rightPar);
    }

    @CheckForNull
    private ArgList argList(@Nullable AstNode argList) {
        if (argList != null) {
            List<Argument> arguments = argList.getChildren(new AstNodeType[]{PythonGrammar.ARGUMENT}).stream().map(this::argument).collect(Collectors.toList());
            return new ArgListImpl(argList, arguments);
        }
        return null;
    }

    private static void checkGeneratorExpressionInArgument(List<Argument> arguments) {
        List nonParenthesizedGeneratorExpressions = arguments.stream().filter(arg -> arg.expression().is(Tree.Kind.GENERATOR_EXPR) && !arg.expression().firstToken().value().equals("(")).collect(Collectors.toList());
        if (!nonParenthesizedGeneratorExpressions.isEmpty() && arguments.size() > 1) {
            int line = ((Argument)nonParenthesizedGeneratorExpressions.get(0)).firstToken().line();
            throw new RecognitionException(line, "Parse error at line " + line + ": Generator expression must be parenthesized if not sole argument.");
        }
    }

    public Argument argument(AstNode astNode) {
        AstNode compFor = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.COMP_FOR});
        if (compFor != null) {
            Expression expression = this.expression(astNode.getFirstChild());
            ComprehensionExpressionImpl comprehension = new ComprehensionExpressionImpl(Tree.Kind.GENERATOR_EXPR, expression.firstToken(), expression, this.compFor(compFor), PythonTreeMaker.toPyToken(compFor.getLastToken()));
            return new ArgumentImpl(astNode, comprehension, null, null);
        }
        AstNode assign = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.ASSIGN});
        org.sonar.python.api.tree.Token star = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.MUL}) == null ? null : PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.MUL}).getToken());
        org.sonar.python.api.tree.Token starStar = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.MUL_MUL}) == null ? null : PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.MUL_MUL}).getToken());
        Expression arg = this.expression(astNode.getLastChild(new AstNodeType[]{PythonGrammar.TEST}));
        if (assign != null) {
            AstNode nameNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TEST}).getFirstChild(new AstNodeType[]{PythonGrammar.ATOM}).getFirstChild(new AstNodeType[]{PythonGrammar.NAME});
            return new ArgumentImpl(astNode, PythonTreeMaker.name(nameNode), arg, PythonTreeMaker.toPyToken(assign.getToken()), star, starStar);
        }
        return new ArgumentImpl(astNode, arg, star, starStar);
    }

    private Expression binaryExpression(AstNode astNode) {
        List children = astNode.getChildren();
        Expression result = this.expression((AstNode)children.get(0));
        for (int i = 1; i < astNode.getNumberOfChildren(); i += 2) {
            org.sonar.python.api.tree.Token notToken;
            AstNode operator = (AstNode)children.get(i);
            Expression rightOperand = this.expression(operator.getNextSibling());
            AstNode not = operator.getFirstChild(new AstNodeType[]{PythonKeyword.NOT});
            org.sonar.python.api.tree.Token token = notToken = not == null ? null : PythonTreeMaker.toPyToken(not.getToken());
            result = PythonKeyword.IN.equals(operator.getLastToken().getType()) ? new InExpressionImpl(result, notToken, PythonTreeMaker.toPyToken(operator.getLastToken()), rightOperand) : (PythonKeyword.IS.equals(operator.getToken().getType()) ? new IsExpressionImpl(result, PythonTreeMaker.toPyToken(operator.getToken()), notToken, rightOperand) : new BinaryExpressionImpl(result, PythonTreeMaker.toPyToken(operator.getToken()), rightOperand));
        }
        return result;
    }

    public LambdaExpression lambdaExpression(AstNode astNode) {
        org.sonar.python.api.tree.Token lambdaKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonKeyword.LAMBDA}).getToken());
        org.sonar.python.api.tree.Token colonToken = PythonTreeMaker.toPyToken(astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON}).getToken());
        Expression body = this.expression(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TEST, PythonGrammar.TEST_NOCOND}));
        AstNode varArgsListNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.VARARGSLIST});
        ParameterListImpl argListTree = null;
        if (varArgsListNode != null) {
            List<AnyParameter> parameters = varArgsListNode.getChildren(new AstNodeType[]{PythonGrammar.FPDEF, PythonGrammar.NAME}).stream().map(this::parameter).collect(Collectors.toList());
            argListTree = new ParameterListImpl(varArgsListNode, parameters);
        }
        return new LambdaExpressionImpl(astNode, lambdaKeyword, colonToken, body, argListTree);
    }

    private AnyParameter parameter(AstNode parameter) {
        AstNode prevSibling = parameter.getPreviousSibling();
        if (parameter.is(new AstNodeType[]{PythonGrammar.NAME})) {
            return new ParameterImpl(parameter, PythonTreeMaker.toPyToken(prevSibling.getToken()), PythonTreeMaker.name(parameter), null, null, null);
        }
        AstNode paramList = parameter.getFirstChild(new AstNodeType[]{PythonGrammar.TFPLIST, PythonGrammar.FPLIST});
        if (paramList != null) {
            List<AnyParameter> params = paramList.getChildren(new AstNodeType[]{PythonGrammar.TFPDEF, PythonGrammar.FPDEF}).stream().map(this::parameter).collect(Collectors.toList());
            List<org.sonar.python.api.tree.Token> commas = PythonTreeMaker.toPyToken(paramList.getChildren(new AstNodeType[]{PythonPunctuator.COMMA}).stream().map(AstNode::getToken).collect(Collectors.toList()));
            return new TupleParameterImpl(parameter, params, commas);
        }
        org.sonar.python.api.tree.Token starOrStarStar = null;
        if (prevSibling != null && prevSibling.is(new AstNodeType[]{PythonPunctuator.MUL, PythonPunctuator.MUL_MUL})) {
            starOrStarStar = PythonTreeMaker.toPyToken(prevSibling.getToken());
        }
        Name name = PythonTreeMaker.name(parameter.getFirstChild(new AstNodeType[]{PythonGrammar.NAME}));
        AstNode nextSibling = parameter.getNextSibling();
        org.sonar.python.api.tree.Token assignToken = null;
        Expression defaultValue = null;
        if (nextSibling != null && nextSibling.is(new AstNodeType[]{PythonPunctuator.ASSIGN})) {
            assignToken = PythonTreeMaker.toPyToken(nextSibling.getToken());
            defaultValue = this.expression(nextSibling.getNextSibling());
        }
        TypeAnnotationImpl typeAnnotation = null;
        AstNode testNode = parameter.getFirstChild(new AstNodeType[]{PythonGrammar.TEST});
        if (testNode != null) {
            org.sonar.python.api.tree.Token colonToken = PythonTreeMaker.toPyToken(parameter.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON}).getToken());
            typeAnnotation = new TypeAnnotationImpl(colonToken, this.expression(testNode));
        }
        return new ParameterImpl(parameter, starOrStarStar, name, typeAnnotation, assignToken, defaultValue);
    }

    private static Expression numericLiteral(AstNode astNode) {
        return new NumericLiteralImpl(astNode);
    }

    private static Expression stringLiteral(AstNode astNode) {
        List<StringElement> stringElements = astNode.getChildren(new AstNodeType[]{PythonTokenType.STRING}).stream().map(StringElementImpl::new).collect(Collectors.toList());
        return new StringLiteralImpl(astNode, stringElements);
    }
}

