/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.Name;
import org.sonar.python.api.tree.QualifiedExpression;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class QualifiedExpressionImpl
extends PyTree
implements QualifiedExpression {
    private final Name name;
    private final Expression qualifier;
    private final Token dotToken;
    private final AstNode astNode;

    public QualifiedExpressionImpl(AstNode astNode, Name name, Expression qualifier, Token dotToken) {
        super(qualifier.firstToken(), name.lastToken());
        this.astNode = astNode;
        this.name = name;
        this.qualifier = qualifier;
        this.dotToken = dotToken;
    }

    @Override
    @CheckForNull
    public AstNode astNode() {
        return this.astNode;
    }

    @Override
    public Expression qualifier() {
        return this.qualifier;
    }

    @Override
    public Token dotToken() {
        return this.dotToken;
    }

    @Override
    public Name name() {
        return this.name;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.QUALIFIED_EXPR;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitQualifiedExpression(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.name, this.dotToken, this.qualifier).collect(Collectors.toList());
    }
}

