/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.RaiseStatement;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class RaiseStatementImpl
extends PyTree
implements RaiseStatement {
    private final Token raiseKeyword;
    private final List<Expression> expressions;
    private final Token fromKeyword;
    private final Expression fromExpression;

    public RaiseStatementImpl(AstNode astNode, Token raiseKeyword, List<Expression> expressions, @Nullable Token fromKeyword, @Nullable Expression fromExpression) {
        super(astNode);
        this.raiseKeyword = raiseKeyword;
        this.expressions = expressions;
        this.fromKeyword = fromKeyword;
        this.fromExpression = fromExpression;
    }

    @Override
    public Token raiseKeyword() {
        return this.raiseKeyword;
    }

    @Override
    @CheckForNull
    public Token fromKeyword() {
        return this.fromKeyword;
    }

    @Override
    @CheckForNull
    public Expression fromExpression() {
        return this.fromExpression;
    }

    @Override
    public List<Expression> expressions() {
        return this.expressions;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.RAISE_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitRaiseStatement(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(Collections.singletonList(this.raiseKeyword), this.expressions, Arrays.asList(this.fromKeyword, this.fromExpression)).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

