/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.api.tree.ExpressionList;
import org.sonar.python.api.tree.ReprExpression;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ReprExpressionImpl
extends PyTree
implements ReprExpression {
    private final Token openingBacktick;
    private final ExpressionList expressionListTree;
    private final Token closingBacktick;

    public ReprExpressionImpl(AstNode astNode, Token openingBacktick, ExpressionList expressionListTree, Token closingBacktick) {
        super(astNode);
        this.openingBacktick = openingBacktick;
        this.expressionListTree = expressionListTree;
        this.closingBacktick = closingBacktick;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitRepr(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.openingBacktick, this.expressionListTree, this.closingBacktick).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.REPR;
    }

    @Override
    public Token openingBacktick() {
        return this.openingBacktick;
    }

    @Override
    public ExpressionList expressionList() {
        return this.expressionListTree;
    }

    @Override
    public Token closingBacktick() {
        return this.closingBacktick;
    }
}

