/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.ReturnStatement;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ReturnStatementImpl
extends PyTree
implements ReturnStatement {
    private final Token returnKeyword;
    private final List<Expression> expressionTrees;

    public ReturnStatementImpl(AstNode astNode, Token returnKeyword, List<Expression> expressionTrees) {
        super(astNode);
        this.returnKeyword = returnKeyword;
        this.expressionTrees = expressionTrees;
    }

    @Override
    public Token returnKeyword() {
        return this.returnKeyword;
    }

    @Override
    public List<Expression> expressions() {
        return this.expressionTrees;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.RETURN_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitReturnStatement(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(Collections.singletonList(this.returnKeyword), this.expressionTrees).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

