/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.SliceExpression;
import org.sonar.python.api.tree.SliceList;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class SliceExpressionImpl
extends PyTree
implements SliceExpression {
    private final Expression object;
    private final Token leftBracket;
    private final SliceList sliceList;
    private final Token rightBracket;

    public SliceExpressionImpl(Expression object, Token leftBracket, SliceList sliceList, Token rightBracket) {
        super(object.firstToken(), rightBracket);
        this.object = object;
        this.leftBracket = leftBracket;
        this.sliceList = sliceList;
        this.rightBracket = rightBracket;
    }

    @Override
    public Expression object() {
        return this.object;
    }

    @Override
    public Token leftBracket() {
        return this.leftBracket;
    }

    @Override
    public SliceList sliceList() {
        return this.sliceList;
    }

    @Override
    public Token rightBracket() {
        return this.rightBracket;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitSliceExpression(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.object, this.leftBracket, this.sliceList, this.rightBracket).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.SLICE_EXPR;
    }
}

