/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.SliceItem;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class SliceItemImpl
extends PyTree
implements SliceItem {
    private final Expression lowerBound;
    private final Token boundSeparator;
    private final Expression upperBound;
    private final Token strideSeparator;
    private final Expression stride;

    public SliceItemImpl(AstNode node, @Nullable Expression lowerBound, Token boundSeparator, @Nullable Expression upperBound, @Nullable Token strideSeparator, @Nullable Expression stride) {
        super(node);
        this.lowerBound = lowerBound;
        this.boundSeparator = boundSeparator;
        this.upperBound = upperBound;
        this.strideSeparator = strideSeparator;
        this.stride = stride;
    }

    @Override
    @CheckForNull
    public Expression lowerBound() {
        return this.lowerBound;
    }

    @Override
    public Token boundSeparator() {
        return this.boundSeparator;
    }

    @Override
    @CheckForNull
    public Expression upperBound() {
        return this.upperBound;
    }

    @Override
    @CheckForNull
    public Token strideSeparator() {
        return this.strideSeparator;
    }

    @Override
    @CheckForNull
    public Expression stride() {
        return this.stride;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitSliceItem(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.lowerBound, this.boundSeparator, this.upperBound, this.strideSeparator, this.stride).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.SLICE_ITEM;
    }
}

