/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.api.tree.SliceList;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class SliceListImpl
extends PyTree
implements SliceList {
    private final List<Tree> slices;
    private final List<Token> separators;

    public SliceListImpl(AstNode node, List<Tree> slices, List<Token> separators) {
        super(node);
        this.slices = slices;
        this.separators = separators;
    }

    @Override
    public List<Tree> slices() {
        return this.slices;
    }

    @Override
    public List<Token> separators() {
        return this.separators;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitSliceList(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.slices, this.separators).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.SLICE_LIST;
    }
}

