/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.StarredExpression;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class StarredExpressionImpl
extends PyTree
implements StarredExpression {
    private final Token starToken;
    private final Expression expression;

    public StarredExpressionImpl(AstNode node, Token starToken, Expression expression) {
        super(node);
        this.starToken = starToken;
        this.expression = expression;
    }

    @Override
    public Token starToken() {
        return this.starToken;
    }

    @Override
    public Expression expression() {
        return this.expression;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitStarredExpression(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.starToken, this.expression).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.STARRED_EXPR;
    }
}

