/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.api.tree.Statement;
import org.sonar.python.api.tree.StatementList;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class StatementListImpl
extends PyTree
implements StatementList {
    private List<Statement> statements;
    private final List<Token> tokens;

    public StatementListImpl(AstNode astNode, List<Statement> statements, List<Token> tokens) {
        super(astNode);
        this.statements = statements;
        this.tokens = tokens;
    }

    @Override
    public List<Statement> statements() {
        return this.statements;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitStatementList(this);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.STATEMENT_LIST;
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.statements, this.tokens).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public List<Token> tokens() {
        return this.tokens;
    }
}

