/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.python.api.tree.StringElement;
import org.sonar.python.api.tree.StringLiteral;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class StringLiteralImpl
extends PyTree
implements StringLiteral {
    private final List<StringElement> stringElements;

    StringLiteralImpl(AstNode node, List<StringElement> stringElements) {
        super(node);
        this.stringElements = stringElements;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.STRING_LITERAL;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitStringLiteral(this);
    }

    @Override
    public List<Tree> children() {
        return Collections.unmodifiableList(this.stringElements);
    }

    @Override
    public List<StringElement> stringElements() {
        return this.stringElements;
    }

    @Override
    public String trimmedQuotesValue() {
        return this.stringElements().stream().map(StringElement::trimmedQuotesValue).collect(Collectors.joining());
    }
}

