/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.ElseStatement;
import org.sonar.python.api.tree.ExceptClause;
import org.sonar.python.api.tree.FinallyClause;
import org.sonar.python.api.tree.StatementList;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.api.tree.TryStatement;
import org.sonar.python.tree.PyTree;

public class TryStatementImpl
extends PyTree
implements TryStatement {
    private final Token tryKeyword;
    private final StatementList tryBody;
    private final List<ExceptClause> exceptClauses;
    private final FinallyClause finallyClause;
    private final ElseStatement elseStatement;

    public TryStatementImpl(AstNode astNode, Token tryKeyword, StatementList tryBody, List<ExceptClause> exceptClauses, @Nullable FinallyClause finallyClause, @Nullable ElseStatement elseStatement) {
        super(astNode);
        this.tryKeyword = tryKeyword;
        this.tryBody = tryBody;
        this.exceptClauses = exceptClauses;
        this.finallyClause = finallyClause;
        this.elseStatement = elseStatement;
    }

    @Override
    public Token tryKeyword() {
        return this.tryKeyword;
    }

    @Override
    public List<ExceptClause> exceptClauses() {
        return this.exceptClauses;
    }

    @Override
    @CheckForNull
    public FinallyClause finallyClause() {
        return this.finallyClause;
    }

    @Override
    @CheckForNull
    public ElseStatement elseClause() {
        return this.elseStatement;
    }

    @Override
    public StatementList body() {
        return this.tryBody;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TRY_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTryStatement(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(Arrays.asList(this.tryKeyword, this.tryBody), this.exceptClauses, Arrays.asList(this.finallyClause, this.elseStatement)).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

