/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.api.tree.Tuple;
import org.sonar.python.tree.PyTree;

public class TupleImpl
extends PyTree
implements Tuple {
    private final Token leftParenthesis;
    private final List<Expression> elements;
    private final List<Token> commas;
    private final Token rightParenthesis;

    public TupleImpl(AstNode node, @Nullable Token leftParenthesis, List<Expression> elements, List<Token> commas, @Nullable Token rightParenthesis) {
        super(node);
        this.leftParenthesis = leftParenthesis;
        this.elements = elements;
        this.commas = commas;
        this.rightParenthesis = rightParenthesis;
    }

    @Override
    @CheckForNull
    public Token leftParenthesis() {
        return this.leftParenthesis;
    }

    @Override
    public List<Expression> elements() {
        return this.elements;
    }

    @Override
    public List<Token> commas() {
        return this.commas;
    }

    @Override
    @CheckForNull
    public Token rightParenthesis() {
        return this.rightParenthesis;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTuple(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(Collections.singletonList(this.leftParenthesis), this.elements, this.commas, Collections.singletonList(this.rightParenthesis)).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TUPLE;
    }
}

