/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.api.tree.AnyParameter;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.api.tree.TupleParameter;
import org.sonar.python.tree.PyTree;

public class TupleParameterImpl
extends PyTree
implements TupleParameter {
    private final List<AnyParameter> parameters;
    private final List<Token> commas;

    public TupleParameterImpl(AstNode node, List<AnyParameter> parameters, List<Token> commas) {
        super(node);
        this.parameters = parameters;
        this.commas = commas;
    }

    @Override
    public Token openingParenthesis() {
        return this.firstToken();
    }

    @Override
    public List<AnyParameter> parameters() {
        return this.parameters;
    }

    @Override
    public List<Token> commas() {
        return this.commas;
    }

    @Override
    public Token closingParenthesis() {
        return this.lastToken();
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTupleParameter(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.parameters, this.commas).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TUPLE_PARAMETER;
    }
}

