/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.StatementList;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.api.tree.WhileStatement;
import org.sonar.python.tree.PyTree;

public class WhileStatementImpl
extends PyTree
implements WhileStatement {
    private final Token whileKeyword;
    private final Expression condition;
    private final Token colon;
    private final StatementList body;
    private final Token elseKeyword;
    private final Token elseColon;
    private final StatementList elseBody;

    public WhileStatementImpl(AstNode astNode, Token whileKeyword, Expression condition, Token colon, StatementList body, @Nullable Token elseKeyword, @Nullable Token elseColon, @Nullable StatementList elseBody) {
        super(astNode);
        this.whileKeyword = whileKeyword;
        this.condition = condition;
        this.colon = colon;
        this.body = body;
        this.elseKeyword = elseKeyword;
        this.elseColon = elseColon;
        this.elseBody = elseBody;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.WHILE_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitWhileStatement(this);
    }

    @Override
    public Token whileKeyword() {
        return this.whileKeyword;
    }

    @Override
    public Expression condition() {
        return this.condition;
    }

    @Override
    public Token colon() {
        return this.colon;
    }

    @Override
    public StatementList body() {
        return this.body;
    }

    @Override
    @CheckForNull
    public Token elseKeyword() {
        return this.elseKeyword;
    }

    @Override
    @CheckForNull
    public Token elseColon() {
        return this.elseColon;
    }

    @Override
    @CheckForNull
    public StatementList elseBody() {
        return this.elseBody;
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.whileKeyword, this.condition, this.colon, this.body, this.elseKeyword, this.elseColon, this.elseBody).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

