/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.StatementList;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.api.tree.WithItem;
import org.sonar.python.api.tree.WithStatement;
import org.sonar.python.tree.PyTree;

public class WithStatementImpl
extends PyTree
implements WithStatement {
    private final List<WithItem> withItems;
    private final StatementList statements;
    private final Token asyncKeyword;
    private final boolean isAsync;
    private final Token colon;

    public WithStatementImpl(AstNode node, List<WithItem> withItems, Token colon, StatementList statements, @Nullable Token asyncKeyword) {
        super(node);
        this.withItems = withItems;
        this.colon = colon;
        this.statements = statements;
        this.asyncKeyword = asyncKeyword;
        this.isAsync = asyncKeyword != null;
    }

    @Override
    public List<WithItem> withItems() {
        return this.withItems;
    }

    @Override
    public Token colon() {
        return this.colon;
    }

    @Override
    public StatementList statements() {
        return this.statements;
    }

    @Override
    public boolean isAsync() {
        return this.isAsync;
    }

    @Override
    @CheckForNull
    public Token asyncKeyword() {
        return this.asyncKeyword;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.WITH_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitWithStatement(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(Collections.singletonList(this.asyncKeyword), this.withItems, Arrays.asList(this.colon, this.statements)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static class WithItemImpl
    extends PyTree
    implements WithItem {
        private final Expression test;
        private final Token as;
        private final Expression expr;

        public WithItemImpl(AstNode node, Expression test, @Nullable Token as, @Nullable Expression expr) {
            super(node);
            this.test = test;
            this.as = as;
            this.expr = expr;
        }

        @Override
        public Expression test() {
            return this.test;
        }

        @Override
        @CheckForNull
        public Token as() {
            return this.as;
        }

        @Override
        @CheckForNull
        public Expression expression() {
            return this.expr;
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.WITH_ITEM;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitWithItem(this);
        }

        @Override
        public List<Tree> children() {
            return Stream.of(this.test, this.as, this.expr).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }
}

