/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.metrics;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.Map;
import java.util.Set;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.python.DocstringExtractor;
import org.sonar.python.TokenLocation;
import org.sonar.python.api.PythonMetric;
import org.sonar.python.api.PythonTokenType;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.measures.MetricDef;

public class FileLinesVisitor
extends SquidAstVisitor<Grammar>
implements AstAndTokenVisitor {
    private final FileLinesContextFactory fileLinesContextFactory;
    private boolean seenFirstToken;
    private final boolean ignoreHeaderComments;
    private Set<Integer> noSonar = Sets.newHashSet();
    private Set<Integer> linesOfCode = Sets.newHashSet();
    private Set<Integer> linesOfComments = Sets.newHashSet();
    private Set<Integer> linesOfDocstring = Sets.newHashSet();
    private final FileSystem fileSystem;
    private final Map<InputFile, Set<Integer>> allLinesOfCode;

    public FileLinesVisitor(FileLinesContextFactory fileLinesContextFactory, FileSystem fileSystem, Map<InputFile, Set<Integer>> linesOfCode, boolean ignoreHeaderComments) {
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.fileSystem = fileSystem;
        this.allLinesOfCode = linesOfCode;
        this.ignoreHeaderComments = ignoreHeaderComments;
    }

    public void init() {
        DocstringExtractor.DOCUMENTABLE_NODE_TYPES.stream().forEach(xva$0 -> this.subscribeTo(new AstNodeType[]{xva$0}));
    }

    public void visitFile(AstNode astNode) {
        this.noSonar.clear();
        this.linesOfCode.clear();
        this.linesOfComments.clear();
        this.linesOfDocstring.clear();
        this.seenFirstToken = false;
    }

    public void visitNode(AstNode astNode) {
        Token docstringToken = DocstringExtractor.extractDocstring(astNode);
        if (docstringToken != null) {
            TokenLocation location = new TokenLocation(docstringToken);
            for (int line = location.startLine(); line <= location.endLine(); ++line) {
                this.linesOfDocstring.add(line);
            }
        }
    }

    public void visitToken(Token token) {
        if (token.getType().equals(GenericTokenType.EOF)) {
            return;
        }
        if (!(token.getType().equals((Object)PythonTokenType.DEDENT) || token.getType().equals((Object)PythonTokenType.INDENT) || token.getType().equals((Object)PythonTokenType.NEWLINE))) {
            String[] tokenLines = token.getValue().split("\n", -1);
            for (int line = token.getLine(); line < token.getLine() + tokenLines.length; ++line) {
                this.linesOfCode.add(line);
            }
        }
        if (this.ignoreHeaderComments && !this.seenFirstToken) {
            this.seenFirstToken = true;
            return;
        }
        for (Trivia trivia : token.getTrivia()) {
            if (!trivia.isComment()) continue;
            this.visitComment(trivia);
        }
    }

    public void visitComment(Trivia trivia) {
        String[] commentLines = this.getContext().getCommentAnalyser().getContents(trivia.getToken().getOriginalValue()).split("(\r)?\n|\r", -1);
        int line = trivia.getToken().getLine();
        for (String commentLine : commentLines) {
            if (commentLine.contains("NOSONAR")) {
                this.linesOfComments.remove(line);
                this.noSonar.add(line);
            } else if (!this.getContext().getCommentAnalyser().isBlank(commentLine) && !this.noSonar.contains(line)) {
                this.linesOfComments.add(line);
            }
            ++line;
        }
    }

    public void leaveFile(AstNode astNode) {
        InputFile inputFile = this.fileSystem.inputFile(this.fileSystem.predicates().is(this.getContext().getFile()));
        if (inputFile == null) {
            throw new IllegalStateException("InputFile is null, but it should not be.");
        }
        FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(inputFile);
        for (Integer line : this.linesOfDocstring) {
            this.linesOfCode.remove(line);
            this.linesOfComments.add(line);
        }
        for (int line : this.linesOfCode) {
            fileLinesContext.setIntValue("ncloc_data", line, 1);
        }
        for (int line : this.linesOfComments) {
            fileLinesContext.setIntValue("comment_lines_data", line, 1);
        }
        fileLinesContext.save();
        this.allLinesOfCode.put(inputFile, (Set<Integer>)ImmutableSet.copyOf(this.linesOfCode));
        this.getContext().peekSourceCode().add((MetricDef)PythonMetric.LINES_OF_CODE, (double)this.linesOfCode.size());
        this.getContext().peekSourceCode().add((MetricDef)PythonMetric.COMMENT_LINES, (double)this.linesOfComments.size());
        ((SourceFile)this.getContext().peekSourceCode()).addNoSonarTagLines(this.noSonar);
    }
}

