/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonTokenType;

public class DocstringExtractor {
    public static final Set<AstNodeType> DOCUMENTABLE_NODE_TYPES = ImmutableSet.of((Object)((Object)PythonGrammar.FILE_INPUT), (Object)((Object)PythonGrammar.FUNCDEF), (Object)((Object)PythonGrammar.CLASSDEF));

    private DocstringExtractor() {
    }

    public static Token extractDocstring(AstNode documentableNode) {
        if (documentableNode.is(new AstNodeType[]{PythonGrammar.FILE_INPUT})) {
            return DocstringExtractor.extractModuleDocstring(documentableNode);
        }
        return DocstringExtractor.extractDocstringFromFirstSuite(documentableNode);
    }

    private static Token extractModuleDocstring(AstNode astNode) {
        AstNode firstStatement = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.STATEMENT});
        AstNode firstSimpleStmt = null;
        if (firstStatement != null) {
            firstSimpleStmt = DocstringExtractor.getFirstSimpleStmt(firstStatement);
        }
        return DocstringExtractor.extractDocstringFromSimpleStmt(firstSimpleStmt);
    }

    private static AstNode getFirstSimpleStmt(AstNode statement) {
        AstNode stmtList = statement.getFirstChild(new AstNodeType[]{PythonGrammar.STMT_LIST});
        if (stmtList != null) {
            return stmtList.getFirstChild(new AstNodeType[]{PythonGrammar.SIMPLE_STMT});
        }
        return null;
    }

    private static Token extractDocstringFromFirstSuite(AstNode documentableNode) {
        AstNode suite = documentableNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE});
        AstNode firstStatement = suite.getFirstChild(new AstNodeType[]{PythonGrammar.STATEMENT});
        AstNode firstSimpleStmt = firstStatement == null ? suite.getFirstChild(new AstNodeType[]{PythonGrammar.STMT_LIST}).getFirstChild(new AstNodeType[]{PythonGrammar.SIMPLE_STMT}) : DocstringExtractor.getFirstSimpleStmt(firstStatement);
        return DocstringExtractor.extractDocstringFromSimpleStmt(firstSimpleStmt);
    }

    private static Token extractDocstringFromSimpleStmt(@Nullable AstNode firstSimpleStmt) {
        Token token;
        if (firstSimpleStmt != null && (token = firstSimpleStmt.getToken()).getType().equals((Object)PythonTokenType.STRING)) {
            return token;
        }
        return null;
    }
}

