/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python;

import com.google.common.io.Files;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.impl.Parser;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.sonar.python.PythonConfiguration;
import org.sonar.python.PythonFile;
import org.sonar.python.PythonVisitor;
import org.sonar.python.PythonVisitorContext;
import org.sonar.python.parser.PythonParser;

public class TestPythonVisitorRunner {
    private TestPythonVisitorRunner() {
    }

    public static void scanFile(File file, PythonVisitor ... visitors) {
        PythonVisitorContext context = TestPythonVisitorRunner.createContext(file);
        for (PythonVisitor visitor : visitors) {
            visitor.scanFile(context);
        }
    }

    public static PythonVisitorContext createContext(File file) {
        Parser<Grammar> parser = PythonParser.create(new PythonConfiguration(StandardCharsets.UTF_8));
        TestPythonFile pythonFile = new TestPythonFile(file);
        AstNode rootTree = parser.parse(pythonFile.content());
        return new PythonVisitorContext(rootTree, pythonFile);
    }

    private static class TestPythonFile
    implements PythonFile {
        private final File file;

        public TestPythonFile(File file) {
            this.file = file;
        }

        @Override
        public String content() {
            try {
                return Files.toString((File)this.file, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot read " + this.file, e);
            }
        }

        @Override
        public String fileName() {
            return this.file.getName();
        }
    }
}

