/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.metrics;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.Set;
import org.sonar.python.DocstringExtractor;
import org.sonar.python.PythonVisitor;
import org.sonar.python.TokenLocation;
import org.sonar.python.api.PythonTokenType;

public class FileLinesVisitor
extends PythonVisitor {
    private static final PythonCommentAnalyser COMMENT_ANALYSER = new PythonCommentAnalyser();
    private boolean seenFirstToken;
    private final boolean ignoreHeaderComments;
    private Set<Integer> noSonar = Sets.newHashSet();
    private Set<Integer> linesOfCode = Sets.newHashSet();
    private Set<Integer> linesOfComments = Sets.newHashSet();
    private Set<Integer> linesOfDocstring = Sets.newHashSet();

    public FileLinesVisitor(boolean ignoreHeaderComments) {
        this.ignoreHeaderComments = ignoreHeaderComments;
    }

    @Override
    public Set<AstNodeType> subscribedKinds() {
        return DocstringExtractor.DOCUMENTABLE_NODE_TYPES;
    }

    @Override
    public void visitFile(AstNode astNode) {
        this.noSonar.clear();
        this.linesOfCode.clear();
        this.linesOfComments.clear();
        this.linesOfDocstring.clear();
        this.seenFirstToken = false;
    }

    @Override
    public void visitNode(AstNode astNode) {
        Token docstringToken = DocstringExtractor.extractDocstring(astNode);
        if (docstringToken != null) {
            TokenLocation location = new TokenLocation(docstringToken);
            for (int line = location.startLine(); line <= location.endLine(); ++line) {
                this.linesOfDocstring.add(line);
            }
        }
    }

    @Override
    public void visitToken(Token token) {
        if (token.getType().equals(GenericTokenType.EOF)) {
            return;
        }
        if (!(token.getType().equals((Object)PythonTokenType.DEDENT) || token.getType().equals((Object)PythonTokenType.INDENT) || token.getType().equals((Object)PythonTokenType.NEWLINE))) {
            String[] tokenLines = token.getValue().split("\n", -1);
            for (int line = token.getLine(); line < token.getLine() + tokenLines.length; ++line) {
                this.linesOfCode.add(line);
            }
        }
        if (this.ignoreHeaderComments && !this.seenFirstToken) {
            this.seenFirstToken = true;
            return;
        }
        for (Trivia trivia : token.getTrivia()) {
            if (!trivia.isComment()) continue;
            this.visitComment(trivia);
        }
    }

    public void visitComment(Trivia trivia) {
        String[] commentLines = COMMENT_ANALYSER.getContents(trivia.getToken().getOriginalValue()).split("(\r)?\n|\r", -1);
        int line = trivia.getToken().getLine();
        for (String commentLine : commentLines) {
            if (commentLine.contains("NOSONAR")) {
                this.linesOfComments.remove(line);
                this.noSonar.add(line);
            } else if (!COMMENT_ANALYSER.isBlank(commentLine) && !this.noSonar.contains(line)) {
                this.linesOfComments.add(line);
            }
            ++line;
        }
    }

    @Override
    public void leaveFile(AstNode astNode) {
        for (Integer line : this.linesOfDocstring) {
            this.linesOfCode.remove(line);
            this.linesOfComments.add(line);
        }
    }

    public Set<Integer> getLinesWithNoSonar() {
        return ImmutableSet.copyOf(this.noSonar);
    }

    public Set<Integer> getLinesOfCode() {
        return ImmutableSet.copyOf(this.linesOfCode);
    }

    public Set<Integer> getLinesOfComments() {
        return ImmutableSet.copyOf(this.linesOfComments);
    }

    private static class PythonCommentAnalyser {
        private PythonCommentAnalyser() {
        }

        public boolean isBlank(String line) {
            for (int i = 0; i < line.length(); ++i) {
                if (!Character.isLetterOrDigit(line.charAt(i))) continue;
                return false;
            }
            return true;
        }

        public String getContents(String comment) {
            return comment.substring(comment.indexOf(35));
        }
    }
}

