/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.PythonVisitor;
import org.sonar.python.PythonVisitorContext;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.semantic.Symbol;
import org.sonar.python.semantic.SymbolTable;
import org.sonar.sslr.ast.AstSelect;

public class SymbolTableBuilderVisitor
extends PythonVisitor {
    private Map<AstNode, Scope> scopesByRootTree;
    private Set<AstNode> allReadUsages;

    public SymbolTable symbolTable() {
        return new SymbolTablImpl(this.scopesByRootTree);
    }

    @Override
    public void scanFile(PythonVisitorContext context) {
        super.scanFile(context);
        new FirstPhaseVisitor().scanFile(context);
        new SecondPhaseVisitor().scanFile(context);
    }

    @Override
    public void visitFile(AstNode node) {
        this.scopesByRootTree = new HashMap<AstNode, Scope>();
        this.allReadUsages = new HashSet<AstNode>();
    }

    private class ClassVariableAssignmentVisitor
    extends SecondPhaseVisitor {
        public ClassVariableAssignmentVisitor(AstNode classTree) {
            this.enterScope(classTree);
        }
    }

    private class SecondPhaseVisitor
    extends ScopeVisitor {
        private SecondPhaseVisitor() {
        }

        @Override
        public Set<AstNodeType> subscribedKinds() {
            HashSet<PythonGrammar> set = new HashSet<PythonGrammar>();
            set.add(PythonGrammar.FUNCDEF);
            set.add(PythonGrammar.CLASSDEF);
            set.add(PythonGrammar.ATOM);
            set.add(PythonGrammar.DOTTED_NAME);
            return Collections.unmodifiableSet(set);
        }

        @Override
        public void visitNode(AstNode node) {
            Scope currentScope;
            SymbolImpl symbol;
            AstNode nameNode;
            super.visitNode(node);
            if (node.is(new AstNodeType[]{PythonGrammar.ATOM, PythonGrammar.DOTTED_NAME}) && (nameNode = node.getFirstChild(new AstNodeType[]{PythonGrammar.NAME})) != null && (symbol = (currentScope = (Scope)SymbolTableBuilderVisitor.this.scopesByRootTree.get(this.currentScopeRootTree())).resolve(nameNode.getTokenValue())) != null && !symbol.writeUsages.contains(nameNode) && !SymbolTableBuilderVisitor.this.allReadUsages.contains(nameNode)) {
                symbol.addReadUsage(nameNode);
                SymbolTableBuilderVisitor.this.allReadUsages.add(nameNode);
            }
        }
    }

    private static class SymbolImpl
    implements Symbol {
        private final String name;
        private final AstNode scopeRootTree;
        private final Set<AstNode> writeUsages = new HashSet<AstNode>();
        private final Set<AstNode> readUsages = new HashSet<AstNode>();

        private SymbolImpl(String name, AstNode scopeRootTree) {
            this.name = name;
            this.scopeRootTree = scopeRootTree;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public AstNode scopeTree() {
            return this.scopeRootTree;
        }

        @Override
        public Set<AstNode> writeUsages() {
            return Collections.unmodifiableSet(this.writeUsages);
        }

        @Override
        public Set<AstNode> readUsages() {
            return Collections.unmodifiableSet(this.readUsages);
        }

        public void addWriteUsage(AstNode nameNode) {
            this.writeUsages.add(nameNode);
        }

        public void addReadUsage(AstNode nameNode) {
            this.readUsages.add(nameNode);
        }
    }

    private static class Scope {
        private final AstNode rootTree;
        private final Scope parent;
        private final Map<String, Symbol> symbolsByName = new HashMap<String, Symbol>();
        private final Set<Symbol> symbols = new HashSet<Symbol>();
        private final Set<String> globalNames = new HashSet<String>();
        private final Set<String> nonlocalNames = new HashSet<String>();

        private Scope(@Nullable Scope parent, AstNode rootTree) {
            this.parent = parent;
            this.rootTree = rootTree;
        }

        private Set<Symbol> symbols() {
            return Collections.unmodifiableSet(this.symbols);
        }

        public void addWriteUsage(AstNode nameNode) {
            SymbolImpl symbol;
            String symbolName = nameNode.getTokenValue();
            if (!(this.symbolsByName.containsKey(symbolName) || this.globalNames.contains(symbolName) || this.nonlocalNames.contains(symbolName))) {
                symbol = new SymbolImpl(symbolName, this.rootTree);
                this.symbols.add(symbol);
                this.symbolsByName.put(symbolName, symbol);
            }
            if ((symbol = this.resolve(symbolName)) != null) {
                symbol.addWriteUsage(nameNode);
            }
        }

        @CheckForNull
        public SymbolImpl resolve(String symbolName) {
            if (this.nonlocalNames.contains(symbolName)) {
                return this.resolveNonlocal(symbolName);
            }
            Symbol symbol = this.symbolsByName.get(symbolName);
            if (this.parent == null || symbol != null) {
                return (SymbolImpl)symbol;
            }
            if (this.globalNames.contains(symbolName)) {
                return this.rootScope().resolve(symbolName);
            }
            return this.parent.resolve(symbolName);
        }

        private SymbolImpl resolveNonlocal(String symbolName) {
            Scope scope = this.parent;
            while (scope.parent != null) {
                Symbol symbol = scope.symbolsByName.get(symbolName);
                if (symbol != null) {
                    return (SymbolImpl)symbol;
                }
                scope = scope.parent;
            }
            return null;
        }

        private Scope rootScope() {
            Scope scope = this;
            while (scope.parent != null) {
                scope = scope.parent;
            }
            return scope;
        }

        private void addGlobalName(String name) {
            this.globalNames.add(name);
        }

        private void addNonlocalName(String name) {
            this.nonlocalNames.add(name);
        }
    }

    private static class SymbolTablImpl
    implements SymbolTable {
        private final Map<AstNode, Scope> scopesByRootTree;

        public SymbolTablImpl(Map<AstNode, Scope> scopesByRootTree) {
            this.scopesByRootTree = scopesByRootTree;
        }

        @Override
        public Set<Symbol> symbols(AstNode scopeTree) {
            Scope scope = this.scopesByRootTree.get(scopeTree);
            return scope == null ? Collections.emptySet() : scope.symbols();
        }
    }

    private class FirstPhaseVisitor
    extends ScopeVisitor {
        private FirstPhaseVisitor() {
        }

        @Override
        public Set<AstNodeType> subscribedKinds() {
            HashSet<PythonGrammar> set = new HashSet<PythonGrammar>();
            set.add(PythonGrammar.FUNCDEF);
            set.add(PythonGrammar.CLASSDEF);
            set.add(PythonGrammar.EXPRESSION_STMT);
            set.add(PythonGrammar.GLOBAL_STMT);
            set.add(PythonGrammar.NONLOCAL_STMT);
            return Collections.unmodifiableSet(set);
        }

        @Override
        public void visitFile(AstNode node) {
            super.visitFile(node);
            this.createScope(node, null);
        }

        @Override
        public void visitNode(AstNode node) {
            Scope currentScope = this.currentScope();
            super.visitNode(node);
            if (node.is(new AstNodeType[]{PythonGrammar.FUNCDEF})) {
                this.createScope(node, currentScope);
                this.createFunctionParameters(node);
            } else if (node.is(new AstNodeType[]{PythonGrammar.CLASSDEF})) {
                this.createScope(node, currentScope);
            } else if (node.is(new AstNodeType[]{PythonGrammar.EXPRESSION_STMT})) {
                this.visitAssignment(node);
            } else if (node.is(new AstNodeType[]{PythonGrammar.GLOBAL_STMT})) {
                node.getChildren(new AstNodeType[]{PythonGrammar.NAME}).forEach(name -> this.currentScope().addGlobalName(name.getTokenValue()));
            } else if (node.is(new AstNodeType[]{PythonGrammar.NONLOCAL_STMT})) {
                node.getChildren(new AstNodeType[]{PythonGrammar.NAME}).forEach(name -> this.currentScope().addNonlocalName(name.getTokenValue()));
            }
        }

        private void visitAssignment(AstNode node) {
            for (AstNode assignOperator : node.getChildren(new AstNodeType[]{PythonPunctuator.ASSIGN, PythonGrammar.AUGASSIGN, PythonGrammar.ANNASSIGN})) {
                AstNode target = assignOperator.getPreviousSibling();
                if (assignOperator.is(new AstNodeType[]{PythonGrammar.ANNASSIGN})) {
                    assignOperator = assignOperator.getFirstChild(new AstNodeType[]{PythonPunctuator.ASSIGN});
                }
                if (assignOperator == null) continue;
                if (this.currentScopeRootTree().is(new AstNodeType[]{PythonGrammar.CLASSDEF})) {
                    new ClassVariableAssignmentVisitor(this.currentScopeRootTree()).scanNode(assignOperator.getNextSibling());
                }
                if (target.getTokens().size() != 1) continue;
                this.addWriteUsage(target.getFirstDescendant(new AstNodeType[]{PythonGrammar.NAME}));
            }
        }

        private void createFunctionParameters(AstNode functionTree) {
            AstNode parameters = functionTree.getFirstChild(new AstNodeType[]{PythonGrammar.TYPEDARGSLIST});
            if (parameters == null) {
                return;
            }
            AstSelect parameterNames = parameters.select().descendants((AstNodeType)PythonGrammar.TFPDEF).children((AstNodeType)PythonGrammar.NAME);
            for (AstNode parameterName : parameterNames) {
                this.addWriteUsage(parameterName);
            }
        }

        private void createScope(AstNode node, @Nullable Scope parent) {
            SymbolTableBuilderVisitor.this.scopesByRootTree.put(node, new Scope(parent, node));
        }

        private void addWriteUsage(AstNode nameNode) {
            this.currentScope().addWriteUsage(nameNode);
        }

        private Scope currentScope() {
            return (Scope)SymbolTableBuilderVisitor.this.scopesByRootTree.get(this.currentScopeRootTree());
        }
    }

    private static class ScopeVisitor
    extends PythonVisitor {
        private Deque<AstNode> scopeRootTrees = new LinkedList<AstNode>();

        private ScopeVisitor() {
        }

        @Override
        public void visitFile(AstNode node) {
            this.enterScope(node);
        }

        public void enterScope(AstNode node) {
            this.scopeRootTrees.push(node);
        }

        @Override
        public void visitNode(AstNode node) {
            if (node.is(new AstNodeType[]{PythonGrammar.FUNCDEF, PythonGrammar.CLASSDEF})) {
                this.enterScope(node);
            }
        }

        @Override
        public void leaveNode(AstNode node) {
            if (node.is(new AstNodeType[]{PythonGrammar.FUNCDEF, PythonGrammar.CLASSDEF})) {
                this.scopeRootTrees.pop();
            }
        }

        public AstNode currentScopeRootTree() {
            return this.scopeRootTrees.peek();
        }
    }
}

