/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.channel;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.LexerException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.sslr.channel.Channel;
import org.sonar.sslr.channel.CodeReader;

public class RegexpChannel
extends Channel<Lexer> {
    private final StringBuilder tmpBuilder = new StringBuilder();
    private final TokenType type;
    private final Matcher matcher;
    private final String regexp;
    private final Token.Builder tokenBuilder = Token.builder();

    public RegexpChannel(TokenType type, String regexp) {
        this.matcher = Pattern.compile(regexp).matcher("");
        this.type = type;
        this.regexp = regexp;
    }

    @Override
    public boolean consume(CodeReader code, Lexer lexer) {
        try {
            if (code.popTo(this.matcher, this.tmpBuilder) > 0) {
                String value = this.tmpBuilder.toString();
                Token token = this.tokenBuilder.setType(this.type).setValueAndOriginalValue(value).setURI(lexer.getURI()).setLine(code.getPreviousCursor().getLine()).setColumn(code.getPreviousCursor().getColumn()).build();
                lexer.addToken(token);
                this.tmpBuilder.delete(0, this.tmpBuilder.length());
                return true;
            }
            return false;
        }
        catch (StackOverflowError e) {
            throw new LexerException("The regular expression " + this.regexp + " has led to a stack overflow error. This error is certainly due to an inefficient use of alternations. See http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=5050507", e);
        }
    }
}

