/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.python.checks.CheckList;
import org.sonarsource.analyzer.commons.RuleMetadataLoader;

public class PythonRuleRepository
implements RulesDefinition {
    private static final String REPOSITORY_NAME = "SonarAnalyzer";
    private static final String RESOURCE_FOLDER = "org/sonar/l10n/py/rules/python";
    private static final Set<String> TEMPLATE_RULE_KEYS = new HashSet<String>(Arrays.asList("XPath", "CommentRegularExpression"));

    public void define(RulesDefinition.Context context) {
        RulesDefinition.NewRepository repository = context.createRepository("python", "py").setName(REPOSITORY_NAME);
        PythonRuleRepository.getRuleMetadataLoader().addRulesByAnnotatedClass(repository, PythonRuleRepository.getCheckClasses());
        repository.rules().stream().filter(rule -> TEMPLATE_RULE_KEYS.contains(rule.key())).forEach(rule -> rule.setTemplate(true));
        repository.done();
    }

    private static RuleMetadataLoader getRuleMetadataLoader() {
        return new RuleMetadataLoader(RESOURCE_FOLDER, "org/sonar/l10n/py/rules/python/Sonar_way_profile.json");
    }

    private static List<Class> getCheckClasses() {
        return StreamSupport.stream(CheckList.getChecks().spliterator(), false).collect(Collectors.toList());
    }
}

