/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;

@Rule(key="S1763")
public class AfterJumpStatementCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S1763";
    private static final String MESSAGE = "Remove the code after this \"%s\".";

    @Override
    public Set<AstNodeType> subscribedKinds() {
        return AfterJumpStatementCheck.immutableSet(PythonGrammar.RETURN_STMT, PythonGrammar.RAISE_STMT, PythonGrammar.BREAK_STMT, PythonGrammar.CONTINUE_STMT);
    }

    @Override
    public void visitNode(AstNode node) {
        AstNode simpleStatement = node.getParent();
        AstNode nextSibling = simpleStatement.getNextSibling();
        if (nextSibling != null && nextSibling.getNextSibling() != null) {
            this.raiseIssue(node);
            return;
        }
        AstNode stmtList = simpleStatement.getParent();
        if (stmtList.getParent().is(PythonGrammar.STATEMENT) && (nextSibling = stmtList.getParent().getNextSibling()) != null && nextSibling.getNextSibling() != null) {
            this.raiseIssue(node);
        }
    }

    private void raiseIssue(AstNode node) {
        this.addIssue(node, String.format(MESSAGE, node.getTokenValue()));
    }
}

