/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import java.util.LinkedList;
import java.util.List;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.checks.CheckUtils;

public class NewSymbolsAnalyzer {
    private List<Token> symbols;

    public List<Token> getClassFields(AstNode classDef) {
        this.symbols = new LinkedList<Token>();
        this.findFieldsInClassBody(classDef);
        List<AstNode> methods = classDef.getFirstChild(PythonGrammar.SUITE).getDescendants(PythonGrammar.FUNCDEF);
        for (AstNode method : methods) {
            if (!NewSymbolsAnalyzer.belongToClass(classDef, method)) continue;
            this.addFieldsInMethod(method);
        }
        return this.symbols;
    }

    private static boolean belongToClass(AstNode classDef, AstNode methodOrStmt) {
        return classDef.equals(methodOrStmt.getFirstAncestor(PythonGrammar.CLASSDEF, PythonGrammar.FUNCDEF));
    }

    private void addFieldsInMethod(AstNode method) {
        AstNode suite = method.getFirstChild(PythonGrammar.SUITE);
        List<AstNode> expressions = suite.getDescendants(PythonGrammar.EXPRESSION_STMT);
        for (AstNode expression : expressions) {
            if (!CheckUtils.isAssignmentExpression(expression)) continue;
            this.addSelfDotIdentifiersFromLongAssignmentExpression(expression);
        }
    }

    private static List<AstNode> getTestsFromLongAssignmentExpression(AstNode expression) {
        LinkedList<AstNode> tests = new LinkedList<AstNode>();
        AstNode lastAssign = expression.getLastChild(PythonPunctuator.ASSIGN);
        for (AstNode node : expression.getChildren()) {
            if (node.is(PythonGrammar.TESTLIST_STAR_EXPR)) {
                tests.addAll(node.getDescendants(PythonGrammar.TEST));
                continue;
            }
            if (node != lastAssign) continue;
            break;
        }
        return tests;
    }

    public void addSelfDotIdentifiersFromLongAssignmentExpression(AstNode expression) {
        List<AstNode> tests = NewSymbolsAnalyzer.getTestsFromLongAssignmentExpression(expression);
        for (AstNode test : tests) {
            this.addSelfField(test);
        }
    }

    public void addSimpleIdentifiersFromLongAssignmentExpression(AstNode expression) {
        List<AstNode> tests = NewSymbolsAnalyzer.getTestsFromLongAssignmentExpression(expression);
        for (AstNode test : tests) {
            this.addSimpleField(test);
        }
    }

    private void addSelfField(AstNode test) {
        Token token;
        AstNode trailer;
        if ("self".equals(test.getTokenValue()) && (trailer = test.getFirstDescendant(PythonGrammar.TRAILER)) != null && trailer.getFirstChild(PythonGrammar.NAME) != null && !CheckUtils.containsValue(this.symbols, (token = trailer.getFirstChild(PythonGrammar.NAME).getToken()).getValue())) {
            this.symbols.add(token);
        }
    }

    private void addSimpleField(AstNode test) {
        Token token = test.getToken();
        if (test.getNumberOfChildren() == 1 && test.getFirstChild().is(PythonGrammar.ATOM) && token.getType().equals(GenericTokenType.IDENTIFIER) && !CheckUtils.containsValue(this.symbols, token.getValue())) {
            this.symbols.add(token);
        }
    }

    private List<Token> findFieldsInClassBody(AstNode classDef) {
        List<AstNode> statements = classDef.getFirstChild(PythonGrammar.SUITE).getChildren(PythonGrammar.STATEMENT);
        LinkedList<AstNode> expressions = new LinkedList<AstNode>();
        for (AstNode statement : statements) {
            expressions.addAll(statement.getDescendants(PythonGrammar.EXPRESSION_STMT));
        }
        for (AstNode expression : expressions) {
            if (!CheckUtils.isAssignmentExpression(expression) || !NewSymbolsAnalyzer.belongToClass(classDef, expression)) continue;
            this.addSimpleIdentifiersFromLongAssignmentExpression(expression);
        }
        return this.symbols;
    }

    public List<Token> getVariablesFromLongAssignmentExpression(List<Token> varNames, AstNode expression) {
        this.symbols = varNames;
        this.addSimpleIdentifiersFromLongAssignmentExpression(expression);
        return this.symbols;
    }
}

