/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonPunctuator;

@Rule(key="PreIncrementDecrement")
public class PreIncrementDecrementCheck
extends PythonCheck {
    public static final String CHECK_KEY = "PreIncrementDecrement";
    private static final String MESSAGE = "This statement doesn't produce the expected result, replace use of non-existent pre-%srement operator";

    @Override
    public Set<AstNodeType> subscribedKinds() {
        return Collections.singleton(PythonGrammar.FACTOR);
    }

    @Override
    public void visitNode(AstNode astNode) {
        List<AstNode> children = astNode.getChildren();
        AstNode firstChild = children.get(0);
        AstNode secondChild = children.get(1);
        if (firstChild.is(PythonPunctuator.PLUS) && secondChild.getFirstChild().is(PythonPunctuator.PLUS)) {
            this.addIssue(astNode, String.format(MESSAGE, "inc"));
        }
        if (firstChild.is(PythonPunctuator.MINUS) && secondChild.getFirstChild().is(PythonPunctuator.MINUS)) {
            this.addIssue(astNode, String.format(MESSAGE, "dec"));
        }
    }
}

