/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.GenericTokenType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheck;

@Rule(key="S104")
public class TooManyLinesInFileCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S104";
    private static final int DEFAULT = 1000;
    @RuleProperty(key="maximum", defaultValue="1000")
    public int maximum = 1000;

    @Override
    public Set<AstNodeType> subscribedKinds() {
        return Collections.singleton(GenericTokenType.EOF);
    }

    @Override
    public void visitNode(AstNode astNode) {
        int lines = astNode.getTokenLine();
        if (lines > this.maximum) {
            String message = "File \"{0}\" has {1} lines, which is greater than {2} authorized. Split it into smaller files.";
            this.addFileIssue(MessageFormat.format(message, this.getContext().pythonFile().fileName(), lines, this.maximum));
        }
    }
}

