/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonPunctuator;

@Rule(key="S1721")
public class UselessParenthesisAfterKeywordCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S1721";
    private static final Map<PythonGrammar, String> KEYWORDS_FOLLOWED_BY_TEST = UselessParenthesisAfterKeywordCheck.initializeKeywordsFollowedByTest();

    private static Map<PythonGrammar, String> initializeKeywordsFollowedByTest() {
        EnumMap<PythonGrammar, String> map = new EnumMap<PythonGrammar, String>(PythonGrammar.class);
        map.put(PythonGrammar.ASSERT_STMT, "assert");
        map.put(PythonGrammar.RAISE_STMT, "raise");
        map.put(PythonGrammar.WHILE_STMT, "while");
        return Collections.unmodifiableMap(map);
    }

    @Override
    public Set<AstNodeType> subscribedKinds() {
        return UselessParenthesisAfterKeywordCheck.immutableSet(PythonGrammar.ASSERT_STMT, PythonGrammar.DEL_STMT, PythonGrammar.IF_STMT, PythonGrammar.FOR_STMT, PythonGrammar.RAISE_STMT, PythonGrammar.RETURN_STMT, PythonGrammar.WHILE_STMT, PythonGrammar.YIELD_EXPR, PythonGrammar.EXCEPT_CLAUSE, PythonGrammar.NOT_TEST);
    }

    @Override
    public void visitNode(AstNode node) {
        String keyword = KEYWORDS_FOLLOWED_BY_TEST.get(node.getType());
        if (keyword != null) {
            this.checkParenthesisOnOnlyChild(node.getFirstChild(PythonGrammar.TEST), keyword, node);
        } else if (node.is(PythonGrammar.DEL_STMT)) {
            this.checkParenthesisOnExprList(node.getFirstChild(PythonGrammar.EXPRLIST), "del", node);
        } else if (node.is(PythonGrammar.IF_STMT)) {
            List<AstNode> testNodes = node.getChildren(PythonGrammar.TEST);
            this.checkParenthesisOnOnlyChild(testNodes.get(0), "if", node);
            if (testNodes.size() > 1) {
                this.checkParenthesisOnOnlyChild(testNodes.get(1), "elif", testNodes.get(1));
            }
        } else if (node.is(PythonGrammar.FOR_STMT)) {
            this.visitForExpression(node);
        } else if (node.is(PythonGrammar.RETURN_STMT)) {
            this.checkParenthesisOnExprList(node.getFirstChild(PythonGrammar.TESTLIST), "return", node);
        } else if (node.is(PythonGrammar.YIELD_EXPR)) {
            this.checkParenthesisOnExprList(node.getFirstChild(PythonGrammar.TESTLIST), "yield", node);
        } else if (node.is(PythonGrammar.EXCEPT_CLAUSE)) {
            this.visitExceptClause(node);
        } else if (node.is(PythonGrammar.NOT_TEST)) {
            this.visitNotTest(node);
        }
    }

    private void visitForExpression(AstNode node) {
        if (node.getFirstChild(PythonGrammar.EXPRLIST).getNumberOfChildren() == 1) {
            this.checkParenthesisOnExprList(node.getFirstChild(PythonGrammar.EXPRLIST), "for", node);
        }
        this.checkParenthesisOnExprList(node.getFirstChild(PythonGrammar.TESTLIST), "in", node);
    }

    private void visitNotTest(AstNode node) {
        boolean hasUselessParenthesis = node.select().children((AstNodeType)PythonGrammar.ATOM).children((AstNodeType)PythonGrammar.TESTLIST_COMP).children((AstNodeType)PythonGrammar.TEST).children(PythonGrammar.ATOM, PythonGrammar.COMPARISON).isNotEmpty();
        if (hasUselessParenthesis) {
            this.checkParenthesis(node.getFirstChild().getNextSibling(), "not", node);
        }
    }

    private void visitExceptClause(AstNode node) {
        int nbTests = node.select().children((AstNodeType)PythonGrammar.TEST).children((AstNodeType)PythonGrammar.ATOM).children((AstNodeType)PythonGrammar.TESTLIST_COMP).children((AstNodeType)PythonGrammar.TEST).size();
        if (nbTests == 1) {
            this.checkParenthesisOnOnlyChild(node.getFirstChild(PythonGrammar.TEST), "except", node);
        }
    }

    private void checkParenthesis(AstNode child, String keyword, AstNode errorNode) {
        if (UselessParenthesisAfterKeywordCheck.isParenthesisExpression(child) && UselessParenthesisAfterKeywordCheck.isOnASingleLine(child)) {
            String message = String.format("Remove the parentheses after this \"%s\" keyword.", keyword);
            this.addLineIssue(message, errorNode.getTokenLine());
        }
    }

    private static boolean isParenthesisExpression(AstNode node) {
        return node.is(PythonGrammar.ATOM) && node.getNumberOfChildren() == 3 && node.getFirstChild().is(PythonPunctuator.LPARENTHESIS);
    }

    private void checkParenthesisOnExprList(@Nullable AstNode testList, String keyword, AstNode errorNode) {
        if (testList != null && testList.getNumberOfChildren() == 1) {
            this.checkParenthesisOnOnlyChild(testList.getFirstChild(), keyword, errorNode);
        }
    }

    private void checkParenthesisOnOnlyChild(@Nullable AstNode parent, String keyword, AstNode errorNode) {
        if (parent != null && parent.getNumberOfChildren() == 1) {
            this.checkParenthesis(parent.getFirstChild(), keyword, errorNode);
        }
    }

    private static boolean isOnASingleLine(AstNode node) {
        return node.getTokenLine() == node.getLastToken().getLine();
    }
}

