/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.cpd;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import java.util.List;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.python.PythonVisitorContext;
import org.sonar.python.TokenLocation;
import org.sonar.python.api.PythonTokenType;

public class PythonCpdAnalyzer {
    private final SensorContext context;

    public PythonCpdAnalyzer(SensorContext context) {
        this.context = context;
    }

    public void pushCpdTokens(InputFile inputFile, PythonVisitorContext visitorContext) {
        AstNode root = visitorContext.rootAstNode();
        if (root != null) {
            NewCpdTokens cpdTokens = this.context.newCpdTokens().onFile(inputFile);
            List<Token> tokens = root.getTokens();
            for (int i = 0; i < tokens.size(); ++i) {
                GenericTokenType nextTokenType;
                Token token = tokens.get(i);
                TokenType currentTokenType = token.getType();
                TokenType tokenType = nextTokenType = i + 1 < tokens.size() ? tokens.get(i + 1).getType() : GenericTokenType.EOF;
                if (!PythonCpdAnalyzer.isNewLineWithIndentationChange(currentTokenType, nextTokenType) && PythonCpdAnalyzer.isIgnoredType(currentTokenType)) continue;
                TokenLocation location = new TokenLocation(token);
                cpdTokens.addToken(location.startLine(), location.startLineOffset(), location.endLine(), location.endLineOffset(), token.getValue());
            }
            cpdTokens.save();
        }
    }

    private static boolean isNewLineWithIndentationChange(TokenType currentTokenType, TokenType nextTokenType) {
        return currentTokenType.equals(PythonTokenType.NEWLINE) && nextTokenType.equals(PythonTokenType.DEDENT);
    }

    private static boolean isIgnoredType(TokenType type) {
        return type.equals(PythonTokenType.NEWLINE) || type.equals(PythonTokenType.DEDENT) || type.equals(PythonTokenType.INDENT) || type.equals(GenericTokenType.EOF);
    }
}

