/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.python.PythonVisitorContext;

public class PythonVisitor {
    private PythonVisitorContext context;

    public Set<AstNodeType> subscribedKinds() {
        return Collections.emptySet();
    }

    public void visitFile(AstNode node) {
    }

    public void leaveFile(AstNode node) {
    }

    public void visitNode(AstNode node) {
    }

    public void visitToken(Token token) {
    }

    public void leaveNode(AstNode node) {
    }

    public PythonVisitorContext getContext() {
        return this.context;
    }

    public void scanFile(PythonVisitorContext context) {
        this.context = context;
        AstNode tree = context.rootAstNode();
        if (tree != null) {
            this.visitFile(tree);
            this.scanNode(tree, this.subscribedKinds());
            this.leaveFile(tree);
        }
    }

    public void scanNode(AstNode node) {
        this.scanNode(node, this.subscribedKinds());
    }

    private void scanNode(AstNode node, Set<AstNodeType> subscribedKinds) {
        List<AstNode> children;
        boolean isSubscribedType = subscribedKinds.contains(node.getType());
        if (isSubscribedType) {
            this.visitNode(node);
        }
        if ((children = node.getChildren()).isEmpty()) {
            for (Token token : node.getTokens()) {
                this.visitToken(token);
            }
        } else {
            for (AstNode child : children) {
                this.scanNode(child, subscribedKinds);
            }
        }
        if (isSubscribedType) {
            this.leaveNode(node);
        }
    }
}

