/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.SubscriptionContext;
import org.sonar.python.api.tree.PyCallExpressionTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.semantic.Symbol;

public abstract class AbstractCallExpressionCheck
extends PythonSubscriptionCheck {
    protected abstract Set<String> functionsToCheck();

    protected abstract String message();

    protected boolean isException(PyCallExpressionTree callExpression) {
        return false;
    }

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::visitNode);
    }

    public void visitNode(SubscriptionContext ctx) {
        PyCallExpressionTree node = (PyCallExpressionTree)ctx.syntaxNode();
        Symbol symbol = ctx.symbolTable().getSymbol(node.callee());
        if (!this.isException(node) && symbol != null && this.functionsToCheck().contains(symbol.qualifiedName())) {
            ctx.addIssue(node, this.message());
        }
    }

    protected static boolean isWithinImport(Tree tree) {
        for (Tree parent = tree.parent(); parent != null; parent = parent.parent()) {
            if (!parent.is(Tree.Kind.IMPORT_NAME) && !parent.is(Tree.Kind.IMPORT_FROM)) continue;
            return true;
        }
        return false;
    }

    protected static <T> Set<T> immutableSet(T ... args) {
        return Collections.unmodifiableSet(new HashSet<T>(Arrays.asList(args)));
    }
}

