/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.api.tree.PyStatementListTree;
import org.sonar.python.api.tree.PyStatementTree;
import org.sonar.python.api.tree.Tree;

@Rule(key="S1763")
public class AfterJumpStatementCheck
extends PythonSubscriptionCheck {
    private static final Map<Tree.Kind, String> JUMP_KEYWORDS_BY_KIND = AfterJumpStatementCheck.jumpKeywordsByKind();

    private static Map<Tree.Kind, String> jumpKeywordsByKind() {
        EnumMap<Tree.Kind, String> map = new EnumMap<Tree.Kind, String>(Tree.Kind.class);
        map.put(Tree.Kind.RETURN_STMT, "return");
        map.put(Tree.Kind.RAISE_STMT, "raise");
        map.put(Tree.Kind.BREAK_STMT, "break");
        map.put(Tree.Kind.CONTINUE_STMT, "continue");
        return map;
    }

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.STATEMENT_LIST, ctx -> {
            List<PyStatementTree> statements = ((PyStatementListTree)ctx.syntaxNode()).statements();
            for (PyStatementTree statement : statements.subList(0, statements.size() - 1)) {
                String jumpKeyword = JUMP_KEYWORDS_BY_KIND.get((Object)statement.getKind());
                if (jumpKeyword == null) continue;
                ctx.addIssue(statement, String.format("Remove the code after this \"%s\".", jumpKeyword));
            }
        });
    }
}

