/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheckAstNode;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.metrics.ComplexityVisitor;

@Rule(key="ClassComplexity")
public class ClassComplexityCheck
extends PythonCheckAstNode {
    private static final int DEFAULT_MAXIMUM_CLASS_COMPLEXITY_THRESHOLD = 200;
    private static final String MESSAGE = "Class has a complexity of %s which is greater than %s authorized.";
    @RuleProperty(key="maximumClassComplexityThreshold", defaultValue="200")
    int maximumClassComplexityThreshold = 200;

    @Override
    public Set<AstNodeType> subscribedKinds() {
        return Collections.singleton(PythonGrammar.CLASSDEF);
    }

    @Override
    public void visitNode(AstNode node) {
        int complexity = ComplexityVisitor.complexity(node);
        if (complexity > this.maximumClassComplexityThreshold) {
            String message = String.format(MESSAGE, complexity, this.maximumClassComplexityThreshold);
            this.addIssue(node.getFirstChild(PythonGrammar.CLASSNAME), message).withCost(complexity - this.maximumClassComplexityThreshold);
        }
    }
}

