/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheckAstNode;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.NewSymbolsAnalyzer;
import org.sonar.sslr.ast.AstSelect;

@Rule(key="S1845")
public class DuplicatedMethodFieldNamesCheck
extends PythonCheckAstNode {
    public static final String CHECK_KEY = "S1845";
    private static final String MESSAGE = "Rename %s \"%s\" to prevent any misunderstanding/clash with %s \"%s\" defined on line %s";

    @Override
    public Set<AstNodeType> subscribedKinds() {
        return Collections.singleton(PythonGrammar.CLASSDEF);
    }

    @Override
    public void visitNode(AstNode astNode) {
        List<Token> fieldNames = new NewSymbolsAnalyzer().getClassFields(astNode);
        List<Token> methodNames = DuplicatedMethodFieldNamesCheck.getFieldNameTokens(astNode);
        this.lookForDuplications(fieldNames, methodNames);
    }

    private static List<Token> getFieldNameTokens(AstNode astNode) {
        LinkedList<Token> methodNames = new LinkedList<Token>();
        AstSelect funcDefSelect = astNode.select().children((AstNodeType)PythonGrammar.SUITE).children((AstNodeType)PythonGrammar.STATEMENT).children((AstNodeType)PythonGrammar.COMPOUND_STMT).children((AstNodeType)PythonGrammar.FUNCDEF);
        for (AstNode node : funcDefSelect) {
            methodNames.add(node.getFirstChild(PythonGrammar.FUNCNAME).getToken());
        }
        return methodNames;
    }

    private void lookForDuplications(List<Token> fieldNames, List<Token> methodNames) {
        List<TokenWithTypeInfo> allTokensWithInfo = DuplicatedMethodFieldNamesCheck.mergeLists(fieldNames, methodNames);
        Collections.sort(allTokensWithInfo, new LineComparator());
        block0: for (int i = 1; i < allTokensWithInfo.size(); ++i) {
            for (int j = i - 1; j >= 0; --j) {
                TokenWithTypeInfo token1 = allTokensWithInfo.get(j);
                TokenWithTypeInfo token2 = allTokensWithInfo.get(i);
                if (!DuplicatedMethodFieldNamesCheck.differOnlyByCapitalization(token1.getValue(), token2.getValue())) continue;
                this.addIssue(token2.token, DuplicatedMethodFieldNamesCheck.getMessage(token1, token2)).secondary(new AstNode(token1.token), "Original");
                continue block0;
            }
        }
    }

    private static boolean differOnlyByCapitalization(String name1, String name2) {
        return name1.equalsIgnoreCase(name2) && !name1.equals(name2);
    }

    private static List<TokenWithTypeInfo> mergeLists(List<Token> fieldNames, List<Token> methodNames) {
        LinkedList<TokenWithTypeInfo> allTokensWithInfo = new LinkedList<TokenWithTypeInfo>();
        for (Token token : fieldNames) {
            allTokensWithInfo.add(new TokenWithTypeInfo(token, "field"));
        }
        for (Token token : methodNames) {
            allTokensWithInfo.add(new TokenWithTypeInfo(token, "method"));
        }
        return allTokensWithInfo;
    }

    private static String getMessage(TokenWithTypeInfo token1, TokenWithTypeInfo token2) {
        return String.format(MESSAGE, token2.getType(), token2.getValue(), token1.getType(), token1.getValue(), token1.getLine());
    }

    private static class LineComparator
    implements Comparator<TokenWithTypeInfo>,
    Serializable {
        private static final long serialVersionUID = 4759444000993633906L;

        private LineComparator() {
        }

        @Override
        public int compare(TokenWithTypeInfo t1, TokenWithTypeInfo t2) {
            return Integer.compare(t1.getLine(), t2.getLine());
        }
    }

    private static class TokenWithTypeInfo {
        private final Token token;
        private final String type;

        TokenWithTypeInfo(Token token, String type) {
            this.token = token;
            this.type = type;
        }

        String getValue() {
            return this.token.getValue();
        }

        int getLine() {
            return this.token.getLine();
        }

        String getType() {
            return this.type;
        }
    }
}

