/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.api.tree.PyStatementListTree;
import org.sonar.python.api.tree.Tree;

@Rule(key="S108")
public class EmptyNestedBlockCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S108";
    private static final String MESSAGE = "Either remove or fill this block of code.";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.STATEMENT_LIST, ctx -> {
            PyStatementListTree statementListTree = (PyStatementListTree)ctx.syntaxNode();
            List nonPassStatements = statementListTree.statements().stream().filter(stmt -> !stmt.is(Tree.Kind.PASS_STMT)).collect(Collectors.toList());
            if (!nonPassStatements.isEmpty()) {
                return;
            }
            Tree parent = statementListTree.parent();
            if (parent.is(Tree.Kind.FUNCDEF) || parent.is(Tree.Kind.CLASSDEF) || parent.is(Tree.Kind.EXCEPT_CLAUSE)) {
                return;
            }
            if (!EmptyNestedBlockCheck.containsComment(statementListTree.tokens())) {
                if (statementListTree.statements().isEmpty()) {
                    ctx.addIssue(statementListTree.firstToken(), MESSAGE);
                } else {
                    ctx.addIssue(statementListTree.statements().get(0), MESSAGE);
                }
            }
        });
    }

    private static boolean containsComment(List<Token> tokens) {
        for (Token token : tokens) {
            for (Trivia trivia : token.getTrivia()) {
                if (!trivia.isComment()) continue;
                return true;
            }
        }
        return false;
    }
}

