/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.IssueLocation;
import org.sonar.python.PythonCheckAstNode;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonPunctuator;

@Rule(key="S2733")
public class ExitHasBadArgumentsCheck
extends PythonCheckAstNode {
    public static final String MESSAGE_ADD = "Add the missing argument.";
    public static final String MESSAGE_REMOVE = "Remove the unnecessary argument.";
    private static final int EXIT_ARGUMENTS_NUMBER = 4;
    public static final String CHECK_KEY = "S2733";

    @Override
    public Set<AstNodeType> subscribedKinds() {
        return Collections.singleton(PythonGrammar.FUNCDEF);
    }

    @Override
    public void visitNode(AstNode node) {
        if (!"__exit__".equals(node.getFirstChild(PythonGrammar.FUNCNAME).getToken().getValue())) {
            return;
        }
        AstNode varArgList = node.getFirstChild(PythonGrammar.TYPEDARGSLIST);
        if (varArgList != null) {
            List<AstNode> arguments = varArgList.getChildren(PythonGrammar.TFPDEF);
            for (AstNode argument : arguments) {
                if (argument.getPreviousSibling() == null || !argument.getPreviousSibling().is(PythonPunctuator.MUL_MUL, PythonPunctuator.MUL)) continue;
                return;
            }
            this.raiseIssue(node, arguments.size());
        } else {
            this.raiseIssue(node, 0);
        }
    }

    private void raiseIssue(AstNode node, int argumentsNumber) {
        if (argumentsNumber != 4) {
            String message = MESSAGE_ADD;
            if (argumentsNumber > 4) {
                message = MESSAGE_REMOVE;
            }
            AstNode funcName = node.getFirstChild(PythonGrammar.FUNCNAME);
            AstNode rightParenthesis = node.getFirstChild(PythonPunctuator.RPARENTHESIS);
            this.addIssue(IssueLocation.preciseLocation(funcName, rightParenthesis, message));
        }
    }
}

